﻿using EduSpider.Model.Entity;
using EduSpider.Repository;
using EduSpider.Utility;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Net.Http;
using System.Text;
using VTX.FW.Helper;

namespace EduSpider.Spiders.ClassInRule
{
    public class StudentManager
    {
        public async void RunAsync(string cookie)
        {
            var request = Utility.HttpHelper.GenerateHttp(cookie);
            int pageIndex = 1, pageCount = 1, pageSize=10000;

            while (pageIndex <= pageCount) 
            {
                var paramStr = $"page={pageIndex}&perpage={pageSize}&isdel=0";
                var content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/x-www-form-urlencoded");
                var response = await request.PostAsync("https://console.eeo.cn/saasajax/student.ajax.php?action=getSchoolStudentListByPage", content);

                var resultStr = response.Content.ReadAsStringAsync().Result ?? string.Empty;
                var result = new JObject();
                if (result.TryFromString(resultStr))
                {
                    var data = (result.ContainsKey("data") ? result["data"] : new JObject()) as JObject;
                    if (data.ContainsKey("totalStudentNum")) {
                        #region 更新PageCount

                        if (pageIndex == 1)
                        {
                            pageCount = (int)Math.Ceiling(data.GetDecimal("totalStudentNum") / pageSize);
                        }

                        #endregion
                        var students = JsonConvert.DeserializeObject<RB_Student>(data.GetString("studentList"));
                    }
                }
            }

        }

    }
}
