﻿using EduSpider.IRepository;
using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Model.Query;
using EduSpider.Repository.Base;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EduSpider.Repository
{
    /// <summary>
    /// 学生作业仓储层实现
    /// </summary>
    public class StuHomeWorkRepository : BaseRepository<RB_Stu_HomeWork>, IStuHomeWorkRepository
    {
        /// <summary>
        /// 批量添加学生家庭作业
        /// </summary>
        /// <param name="homeWorks"></param>
        /// <returns></returns>
        public bool BatchSetStuHomeWorkRepository(List<RB_Stu_HomeWork> homeWorks)
        {
            bool flag;
            flag = base.BatchInsert(homeWorks, isReplace: true);
            return flag;
        }

        /// <summary>
        /// 获取学生作业列表
        /// </summary>
        /// <returns></returns>
        public List<RB_Stu_HomeWork_Extend> GetStuHomeWorkListRepository(CourseQuery query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*,B.homework_title,B.score_type,B.score_value,C.courseName
FROM RB_Stu_HomeWork AS A LEFT JOIN rb_homework AS B ON A.homework_id=B.homework_id
     LEFT JOIN rb_course AS C ON A.course_id=C.courseId
WHERE 1=1
");
            if (query != null)
            {
                if (query.courseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Stu_HomeWork_Extend.course_id), query.courseId);
                }
                if (!string.IsNullOrWhiteSpace(query.QCourseIds))
                {
                    builder.AppendFormat(" AND A.{0} IN({1}) ", nameof(RB_Stu_HomeWork_Extend.course_id), query.QCourseIds);
                }
                if (!string.IsNullOrEmpty(query.StuIds))
                {
                    builder.AppendFormat(" AND A.{0} IN({1}) ", nameof(RB_Stu_HomeWork_Extend.student_uid), query.StuIds);
                }
            }
            return Get<RB_Stu_HomeWork_Extend>(builder.ToString()).ToList();
        }
    }
}
