﻿
using EduSpider.IRepository;
using EduSpider.IServices;
using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Model.Query;
using EduSpider.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VTX.FW.Attr;

namespace EduSpider.Services
{
    /// <summary>
    /// 课程服务实现
    /// </summary>
    public class CourseService : ICourseService
    {
        /// <summary>
        /// 学员课程仓储接口
        /// </summary>
        [Autowired]
        public ICourseStudentRepository CourseStudentRepository { get; set; }

        /// <summary>
        /// 学员家庭作业仓储接口
        /// </summary>
        [Autowired]
        public IStuHomeWorkRepository StuHomeWorkRepository { get; set; }


        /// <summary>
        /// 获取学员课程列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_Student_Extend> GetStuCourseList(CourseQuery query)
        {
            var list = CourseStudentRepository.GetCourseStudentListRepository(query);
            return list;
        }

        /// <summary>
        /// 获取学员考试和家庭作业列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<object> GetStuWorkAndExamList(CourseQuery query)
        {
            List<object> list = new List<object>();
            List<ExamWorkResult> dataList = new List<ExamWorkResult>();
            var homeWorkList = StuHomeWorkRepository.GetStuHomeWorkListRepository(query);
            if (homeWorkList != null && homeWorkList.Count > 0)
            {
                foreach (var item in homeWorkList)
                {
                    ExamWorkResult model = new ExamWorkResult()
                    {
                        CreateTime = item.add_time,
                        ResultType = 1,
                        Title = item.homework_title,
                        Score = item.score,
                        Score_p = item.score_p,
                        ScoreType = item.score_type,
                        Score_Value = item.score_value,
                        HomeWorkStatus = item.status,
                    };
                    dataList.Add(model);
                }
            }
            if (dataList != null && dataList.Count > 0)
            {
                foreach (var item in dataList)
                {
                    list.Add(new
                    {
                        item.ResultType,
                        item.Title,
                        CreateTime = VTX.FW.Helper.ConvertHelper.FormatTime(item.CreateTime),
                        item.Score,
                        item.Score_p,
                        item.ScoreType,
                        item.ScoreTypeStr,
                        item.Score_Value,
                        item.HomeWorkStatus,
                        item.HomeWorkStatusStr,
                    });
                }
            }
            return list;
        }
    }
}
