﻿using EduSpider.Utility.Enum;
using System;
using VTX.FW.Attr;

namespace EduSpider.Model.Entity
{
    /// <summary>
    /// 课程实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Course
    {
        /// <summary>
        /// 课程编号
        /// </summary>
        public int courseId { get; set; }

        /// <summary>
        /// 课程名称
        /// </summary>
        public string courseName { get; set; }

        /// <summary>
        /// 首次课日期
        /// </summary>
        public DateTime? beginTime { get; set; }

        /// <summary>
        /// 完成次数
        /// </summary>
        public int? completeNum { get; set; }

        /// <summary>
        /// 总次数
        /// </summary>
        public int? totalClassNum { get; set; }

        /// <summary>
        /// 有效日期
        /// </summary>
        public DateTime? expiryTime { get; set; }

        /// <summary>
        /// 直播数
        /// </summary>
        public int? liveNum { get; set; }

        /// <summary>
        /// 录课数
        /// </summary>
        public int? recordNum { get; set; }

        /// <summary>
        /// 回放数
        /// </summary>
        public int? openNum { get; set; }

        /// <summary>
        /// 学生数
        /// </summary>
        public int? studentNum { get; set; }

        /// <summary>
        /// 旁听数
        /// </summary>
        public int? auditNum { get; set; }

        /// <summary>
        /// 教师数
        /// </summary>
        public int? teacherNum { get; set; }

        /// <summary>
        /// 课程状态(1-未结课，课程进度未完成,3-已结课)
        /// </summary>
        public int courseStatus { get; set; }

        /// <summary>
        /// 回放地址
        /// </summary>
        public string webCast { get; set; }

        /// <summary>
        /// 班主任编号
        /// </summary>
        public int? teacherId { get; set; }

        /// <summary>
        /// 班主任账号
        /// </summary>
        public string teacherAccount { get; set; }

        /// <summary>
        /// 班主任账号Id
        /// </summary>
        public int? teacherUid { get; set; }

        /// <summary>
        /// 班主任姓名
        /// </summary>
        public string teacherName { get; set; }

        /// <summary>
        /// 班主任头像
        /// </summary>
        public string teacherLogo { get; set; }

        /// <summary>
        /// 课程类型(1-标准课，公开课)
        /// </summary>
        public int courseType { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime addTime { get; set; }

        /// <summary>
        /// 课程图片
        /// </summary>
        public string courseWare { get; set; }

        /// <summary>
        /// 封面图
        /// </summary>
        public string coverImg { get; set; }
    }
}
