﻿using EduSpider.IRepository;
using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Model.Query;
using EduSpider.Repository.Base;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EduSpider.Repository
{
    /// <summary>
    /// 学生作业仓储层实现
    /// </summary>
    public class StuHomeWorkRepository : BaseRepository<RB_Stu_HomeWork>, IStuHomeWorkRepository
    {
        /// <summary>
        /// 评语配置仓储层对象
        /// </summary>
        private readonly CommentRepository commentRepository = new CommentRepository();

        /// <summary>
        /// 批量添加学生家庭作业
        /// </summary>
        /// <param name="homeWorks"></param>
        /// <returns></returns>
        public bool BatchSetStuHomeWorkRepository(List<RB_Stu_HomeWork> homeWorks)
        {
            bool flag;
            flag = base.BatchInsert(homeWorks, isReplace: true);
            return flag;
        }

        /// <summary>
        /// 获取学生作业列表
        /// </summary>
        /// <returns></returns>
        public List<ExamWorkResult> GetStuHomeWorkListRepository(CourseQuery query)
        {
            List<ExamWorkResult> list = new List<ExamWorkResult>();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*,B.homework_title,B.score_value,C.courseName
FROM RB_Stu_HomeWork AS A LEFT JOIN rb_homework AS B ON A.homework_id=B.homework_id
     LEFT JOIN rb_course AS C ON A.course_id=C.courseId
WHERE 1=1
");
            if (query != null)
            {
                if (query.courseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Stu_HomeWork_Extend.course_id), query.courseId);
                }
                if (!string.IsNullOrWhiteSpace(query.QCourseIds))
                {
                    builder.AppendFormat(" AND A.{0} IN({1}) ", nameof(RB_Stu_HomeWork_Extend.course_id), query.QCourseIds);
                }
                if (!string.IsNullOrEmpty(query.StuIds))
                {
                    builder.AppendFormat(" AND A.{0} IN({1}) ", nameof(RB_Stu_HomeWork_Extend.student_uid), query.StuIds);
                }
            }
            var dataList = Get<RB_Stu_HomeWork_Extend>(builder.ToString()).ToList();
            List<ExamWorkResult> homeWorkList = new List<ExamWorkResult>();
            if (dataList != null && dataList.Count > 0)
            {
                int RowNum = 1;
                foreach (var item in dataList)
                {
                    homeWorkList.Add(new ExamWorkResult()
                    {
                        RowNum= RowNum,
                        CreateTime = item.add_time,
                        ResultType = 1,
                        Title = item.homework_title,
                        Score = item.score,
                        Score_p = item.score_p,
                        ScoreType = item.score_type,
                        Score_Value = item.score_value,
                        HomeWorkStatus = item.status,
                    });
                    RowNum++;
                }
            }

            ExamWorkResult firstComment = null;
            ExamWorkResult secondComment = null;
            ExamWorkResult thirdComment = null;
            if (homeWorkList != null && homeWorkList.Count > 0)
            {
                if (homeWorkList.Count >= 5)
                {
                    var firstList = homeWorkList.Where(qitem => qitem.RowNum <= 5).ToList();
                    var score = firstList.Average(qitem => qitem.Score_p) * 100;
                    var commentModel = commentRepository.GetComment(score);
                    firstComment = new ExamWorkResult()
                    {
                        CreateTime = firstList.LastOrDefault().CreateTime.AddMinutes(1),
                        ResultType = 3,
                        Title = "第一阶段评语",
                        Comment = commentModel?.Info
                    };

                }
                if (homeWorkList.Count >= 9)
                {
                    var secondList = homeWorkList.Where(qitem => qitem.RowNum > 5 && qitem.RowNum <= 9).ToList();
                    var score = secondList.Average(qitem => qitem.Score_p) * 100;
                    var commentModel = commentRepository.GetComment(score);
                    secondComment = new ExamWorkResult()
                    {
                        CreateTime = secondList.LastOrDefault().CreateTime.AddMinutes(1),
                        ResultType = 3,
                        Title = "第二阶段评语",
                        Comment = commentModel?.Info
                    };
                }
                if (homeWorkList.Count >= 13)
                {
                    var thirdList = homeWorkList.Where(qitem => qitem.RowNum > 9).ToList();
                    var score = thirdList.Average(qitem => qitem.Score_p) * 100;
                    var commentModel = commentRepository.GetComment(score);
                    thirdComment = new ExamWorkResult()
                    {
                        CreateTime = thirdList.LastOrDefault().CreateTime.AddMinutes(1),
                        ResultType = 3,
                        Title = "第三阶段评语",
                        Comment = commentModel?.Info
                    };
                }
            }

            for (var i = 0; i < homeWorkList.Count; i++)
            {
                var item = homeWorkList[i];

                list.Add(item);
                if (i == 4 && firstComment != null)
                {
                    list.Add(firstComment);
                }
                if (i == 8 && secondComment != null)
                {
                    list.Add(secondComment);
                }
                if (i == 12 && thirdComment != null)
                {
                    list.Add(thirdComment);
                }
            }
            return list;
        }
    }
}
