﻿
using EduSpider.IRepository;
using EduSpider.IServices;
using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Model.Query;
using EduSpider.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VTX.FW.Attr;

namespace EduSpider.Services
{
    /// <summary>
    /// 课程服务实现
    /// </summary>
    public class CourseService : ICourseService
    {
        /// <summary>
        /// 学员课程仓储接口
        /// </summary>
        [Autowired]
        public ICourseStudentRepository CourseStudentRepository { get; set; }

        /// <summary>
        /// 学员家庭作业仓储接口
        /// </summary>
        [Autowired]
        public IStuHomeWorkRepository StuHomeWorkRepository { get; set; }

        /// <summary>
        /// 评语仓储层接口
        /// </summary>
        [Autowired]
        public ICommentRepository CommentRepository { get; set; }

        /// <summary>
        /// 老师课程关联仓储接口
        /// </summary>
        [Autowired]
        public ICourseTeacherRepository CourseTeacherRepository { get; set; }

        /// <summary>
        /// 作业仓储接口
        /// </summary>
        [Autowired]
        public IHomeWorkRepository HomeWorkRepository { get; set; }


        /// <summary>
        /// 获取学员课程列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_Student_Extend> GetStuCourseList(CourseQuery query)
        {
            var list = CourseStudentRepository.GetCourseStudentListRepository(query);
            return list;
        }

        /// <summary>
        /// 获取老师课程列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_Teacher_Extend> GetTeacherCourseList(CourseQuery query)
        {
            var list = CourseTeacherRepository.GetTeacherCourseListRepository(query);
            return list;
        }

        /// <summary>
        /// 获取学员考试和家庭作业列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<object> GetStuWorkAndExamList(CourseQuery query)
        {
            List<object> list = new List<object>();
            List<ExamWorkResult> dataList = new List<ExamWorkResult>();
            var homeWorkList = StuHomeWorkRepository.GetStuHomeWorkListRepository(query);
            if (homeWorkList != null && homeWorkList.Count > 0)
            {
                dataList.AddRange(homeWorkList);
            }
            if (dataList != null && dataList.Count > 0)
            {
                foreach (var item in dataList)
                {
                    list.Add(new
                    {
                        item.ResultType,
                        item.ResultTypeStr,
                        item.Title,
                        CreateTime = VTX.FW.Helper.ConvertHelper.FormatTime(item.CreateTime, 2),
                        item.Score,
                        item.Score_p,
                        item.ScoreType,
                        item.ScoreTypeStr,
                        item.Score_Value,
                        item.HomeWorkStatus,
                        item.HomeWorkStatusStr,
                        item.Comment,
                    });
                }
            }
            return list;
        }

        /// <summary>
        /// 获取课程作业列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<object> GetCourseHomeWork(CourseQuery query)
        {
            List<object> result = new List<object>();
            var list = HomeWorkRepository.GetCourseHomeWorkListRepository(query);
            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    string str = "";
                    if (item.status == 0)
                    {
                        str = "未开始";
                    }
                    else if (item.status == 1)
                    {
                        str = "进行中";
                    }
                    else if (item.status == 2)
                    {
                        str = "已结束";
                    }
                    result.Add(new
                    {
                        HomeWorkId = item.homework_id,
                        HomeWorkTitle = item.homework_title,
                        Status = item.status,
                        StatusStr = str,
                        StuNum = item.num,
                        SubmitNum = item.cnum,
                        ReviewNum = item.rnum,
                        ExcellentNum = item.cream_num
                    });
                }
            }
            return result;
        }
    }
}
