﻿
using EduSpider.IRepository;
using EduSpider.IServices;
using EduSpider.Repository;
using EduSpider.Utility.Data;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VTX.FW.Attr;
using VTX.FW.Helper;

namespace EduSpider.Services
{
    /// <summary>
    /// 考试服务实现
    /// </summary>
    public class ExamService : IExamService
    {
        /// <summary>
        /// 帐号仓储接口
        /// </summary>
        [Autowired]
        private IAccountRepository accountRepository { get; set; }
        /// <summary>
        /// 考试
        /// </summary>
        [Autowired]
        private IExamRepository examRepository { get; set; }
        /// <summary>
        /// 考试题目
        /// </summary>
        [Autowired]
        private IExam_QuestionsRepository exam_QuestionsRepository { get; set; }
        /// <summary>
        /// 考试得分
        /// </summary>
        [Autowired]
        private IExam_ScoreRepository exam_ScoreRepository { get; set; }
        /// <summary>
        /// 学生
        /// </summary>
        [Autowired]
        private IStudentRepository studentRepository { get; set; }


        /// <summary>
        /// 导入考试成绩
        /// </summary>
        /// <param name="path_server"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        public string ImportExcelForStuExamScore(string path_server,int courseId, string examName, int userId)
        {
            var umodel = accountRepository.GetAccountList(new Model.Extend.RB_Account_Extend() { Id = userId }).FirstOrDefault();
            if (umodel == null || umodel.Status == Utility.Enum.DateStateEnum.Delete || umodel.AccountType != Utility.Enum.AccountTypeEnum.Teacher) { return "没有权限操作"; }
            var EQlist = StuExamScoreHelper.GetStuExamScoreData(path_server, out List<StuScoreModel> StuList);
            if (EQlist.Any())
            {
                var AvgList = StuList.Where(x => x.Name == "平均分").ToList();
                StuList = StuList.Where(x => x.Name != "平均分" && !string.IsNullOrWhiteSpace(x.Name)).ToList();
                //根据学生姓名 查询所有的学生账号
                string StuNames = "'" + string.Join("','", StuList.Select(x => x.Name).Distinct()) + "'";
                var sList = studentRepository.GetListForStuName(StuNames);

                //插入考试
                int ExamId = examRepository.Insert(new Model.Entity.RB_Exam()
                {
                    ExamId = 0,
                    CourseId = courseId,
                    ExamName = examName,
                    CreateBy = userId,
                    CreateTime = DateTime.Now,
                    Status = 0
                });
                if (ExamId > 0) {
                    List<Model.Entity.RB_Exam_Questions> InsertEQ = new();
                    //开始插入题目
                    foreach (var item in EQlist)
                    {
                        InsertEQ.Add(new Model.Entity.RB_Exam_Questions()
                        {
                            Id = 0,
                            ExamId = ExamId,
                            Difficulty = item.Difficulty,
                            KnowledgePoint = item.KnowledgePoint,
                            Module = item.Module,
                            Score = item.Score,
                            Sort = item.Id
                        });
                    }
                    exam_QuestionsRepository.BatchInsert(InsertEQ);

                    List<Model.Entity.RB_Exam_Score> InsertScore = new();
                    foreach (var Name in StuList.Select(x => x.Name).Distinct()) {
                        var clist = StuList.Where(x => x.Name == Name).ToList();
                        var stuModel = sList.Where(x => x.StudentName == Name).FirstOrDefault();
                        InsertScore.Add(new Model.Entity.RB_Exam_Score()
                        {
                            Id = 0,
                            ExamId = ExamId,
                            StuId = stuModel?.StudId ?? 0,//匹配学生失败  可能要在后台给与提示， 重新导入
                            StuName = Name,
                            Content = JsonHelper.Serialize(clist.Where(x => x.Id > 0).Select(x => new
                            {
                                Sort = x.Id,
                                x.Score,
                                AvgScore = AvgList.Where(y => y.Id == x.Id).FirstOrDefault()?.Score ?? 0
                            })),
                            TScore = clist.Where(x => x.Id == -1).FirstOrDefault()?.Score ?? 0,
                            Rank = Convert.ToInt32(clist.Where(x => x.Id == -2).FirstOrDefault()?.Score ?? 0),
                            RankRate = clist.Where(x => x.Id == -3).FirstOrDefault()?.Score ?? 0,
                        });
                    }
                    //InsertScore = InsertScore.Where(x => x.StuId > 0).ToList();//暂时只插入匹配到学生的
                    exam_ScoreRepository.BatchInsert(InsertScore);
                }

                return "";
            }
            else
            {
                return "模板匹配失败";
            }
        }

        /// <summary>
        /// 取消备份
        /// </summary>
        /// <param name="path_server"></param>
        /// <param name="courseId"></param>
        /// <param name="examName"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        public string ImportExcelForStuExamScore_V2(string path_server, int courseId, string examName, int userId)
        {
            var umodel = accountRepository.GetAccountList(new Model.Extend.RB_Account_Extend() { Id = userId }).FirstOrDefault();
            if (umodel == null || umodel.Status == Utility.Enum.DateStateEnum.Delete || umodel.AccountType != Utility.Enum.AccountTypeEnum.Teacher) { return "没有权限操作"; }
            var EQlist = StuExamScoreHelper.GetStuExamScoreData(path_server, out List<StuScoreModel> StuList);
            if (EQlist.Any())
            {
                var AvgList = StuList.Where(x => x.Name == "平均分").ToList();
                StuList = StuList.Where(x => x.Name != "平均分" && !string.IsNullOrWhiteSpace(x.Name)).ToList();
                //根据学生姓名 查询所有的学生账号
                string StuNames = "'" + string.Join("','", StuList.Select(x => x.Name).Distinct()) + "'";
                var sList = studentRepository.GetListForStuName(StuNames);

                //插入考试
                int ExamId = examRepository.Insert(new Model.Entity.RB_Exam()
                {
                    ExamId = 0,
                    CourseId = courseId,
                    ExamName = examName,
                    CreateBy = userId,
                    CreateTime = DateTime.Now,
                    Status = 0
                });
                if (ExamId > 0)
                {
                    List<Model.Entity.RB_Exam_Questions> InsertEQ = new();
                    //开始插入题目
                    foreach (var item in EQlist)
                    {
                        InsertEQ.Add(new Model.Entity.RB_Exam_Questions()
                        {
                            Id = 0,
                            ExamId = ExamId,
                            Difficulty = item.Difficulty,
                            KnowledgePoint = item.KnowledgePoint,
                            Module = item.Module,
                            Score = item.Score,
                            Sort = item.Id
                        });
                    }
                    exam_QuestionsRepository.BatchInsert(InsertEQ);

                    List<Model.Entity.RB_Exam_Score> InsertScore = new();
                    //开始插入得分
                    foreach (var item in StuList)
                    {
                        var stuModel = sList.Where(x => x.StudentName == item.Name).FirstOrDefault();
                        InsertScore.Add(new Model.Entity.RB_Exam_Score()
                        {
                            Id = 0,
                            ExamId = ExamId,
                            //Sort = item.Id,
                            StuId = stuModel?.StudId ?? 0,//=0表示未匹配上 暂时=0处理
                            //Score = item.Score,
                            StuName = item.Name
                        });
                    }
                    exam_ScoreRepository.BatchInsert(InsertScore);
                }

                return "";
            }
            else
            {
                return "模板匹配失败";
            }
        }
    }
}
