﻿using EduSpider.IRepository;
using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Model.Query;
using EduSpider.Repository.Base;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VTX.FW.DB.Dapper;

namespace EduSpider.Repository
{
    /// <summary>
    /// 学员评论详情仓储接口
    /// </summary>
    public class StuCommentDetailsRepository : BaseRepository<RB_Stu_CommentDetails>, IStuCommentDetailsRepository
    {
        /// <summary>
        /// 批量新增修改学员评论详情
        /// </summary>
        /// <param name="list"></param>
        /// <returns></returns>
        public bool BatchSetStuCommentDetails(List<RB_Stu_CommentDetails> list)
        {
            foreach (var item in list)
            {
                var defaultModel = GetStuCommentDetailsListRepository(new RB_Stu_CommentDetails_Extend()
                {
                    CourseId = item.CourseId,
                    Times = item.Times,
                    StuUid = item.StuUid,
                    HomeWorkId = item.HomeWorkId,
                }).FirstOrDefault();
                string createTimeStr = "";
                if (defaultModel != null)
                {
                    createTimeStr = VTX.FW.Helper.ConvertHelper.FormatTime(defaultModel.CreateTime.AddSeconds(1));
                }
                else
                {
                    var homeWorkModel = new StuHomeWorkRepository().GetStuHomeWorkDetailsListRepository(new CourseQuery()
                    {
                        CourseId = item.CourseId,
                        HomeWorkId = item.HomeWorkId,
                        StuIds = item.StuUid.ToString()
                    }).FirstOrDefault();
                    if (homeWorkModel != null)
                    {
                        createTimeStr = VTX.FW.Helper.ConvertHelper.FormatTime(homeWorkModel.add_time.AddSeconds(1));
                    }
                }
                if (!string.IsNullOrEmpty(createTimeStr))
                {
                    item.CreateTime = Convert.ToDateTime(createTimeStr);
                }
                else
                {
                    item.CreateTime = DateTime.Now;
                }
                // flag = base.Insert(item) > 0;
            }
            bool flag = BatchInsert(list);
            return flag;
        }

        /// <summary>
        /// 获取学员评价详情
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Stu_CommentDetails_Extend> GetStuCommentDetailsListRepository(RB_Stu_CommentDetails_Extend query)
        {
            StringBuilder builder = new();
            builder.AppendFormat(@"
SELECT A.*,s.StudentName as StuName
FROM RB_Stu_CommentDetails AS A LEFT JOIN rb_student_hk s on A.StuUid = s.StudentUid
WHERE 1=1
");
            if (query != null)
            {
                if (!string.IsNullOrWhiteSpace(query.QCommentMainIds))
                {
                    builder.AppendFormat(@" AND A.{0} IN({1}) ", nameof(RB_Stu_CommentDetails_Extend.CommentMainId), query.QCommentMainIds);
                }
                if (query.CommentMainId > 0)
                {
                    builder.AppendFormat(@" AND A.{0} IN({1}) ", nameof(RB_Stu_CommentDetails_Extend.CommentMainId), query.CommentMainId);
                }
                if (query.CourseId > 0)
                {
                    builder.AppendFormat(@" AND A.{0} IN({1}) ", nameof(RB_Stu_CommentDetails_Extend.CourseId), query.CourseId);
                }
                if (query.Times > 0)
                {
                    builder.AppendFormat(@" AND A.{0} IN({1}) ", nameof(RB_Stu_CommentDetails_Extend.Times), query.Times);
                }
                if (query.StuUid > 0)
                {
                    builder.AppendFormat(@" AND A.{0} IN({1}) ", nameof(RB_Stu_CommentDetails_Extend.StuUid), query.StuUid);
                }
                if (query.HomeWorkId > 0)
                {
                    builder.AppendFormat(@" AND A.{0} ={1} ", nameof(RB_Stu_CommentDetails_Extend.HomeWorkId), query.HomeWorkId);
                }
            }
            return Get<RB_Stu_CommentDetails_Extend>(builder.ToString()).ToList();
        }

        /// <summary>
        /// 修改学生评价
        /// </summary>
        /// <param name="Ids"></param>
        /// <param name="Info"></param>
        /// <returns></returns>
        public bool SetStuCommentDetailsInfoRepository(string Ids,string Info)
        {
            string sql = string.Format("UPDATE RB_Stu_CommentDetails SET Info=@Info WHERE Id IN({0}) ", Ids);
            DynamicParameters parameters = new();
            parameters.Add("Info", Info);
            return base.Execute(sql,parameters) > 0;
        }

        /// <summary>
        /// 根据课程编号和次数修改评价可见状态
        /// </summary>
        /// <param name="CourseId"></param>
        /// <param name="CommentMainId">评价主表编号</param>
        /// <param name="ShowType"></param>
        /// <returns></returns>
        public bool SetStuCommentShowTypeByTimesRepository(int CourseId, int CommentMainId, int ShowType)
        {
            string sql = string.Format("UPDATE RB_Stu_CommentDetails SET ShowType={0} WHERE CourseId={1} AND  CommentMainId={2}", ShowType, CourseId, CommentMainId);
            return base.Execute(sql) > 0;
        }

        /// <summary>
        /// 修改学员评论可见状态
        /// </summary>
        /// <param name="ShowType"></param>
        /// <param name="Ids"></param>
        /// <returns></returns>
        public bool SetStuCommentDetailsShowTypeRepository(int ShowType, string Ids)
        {
            string sql = string.Format("UPDATE RB_Stu_CommentDetails SET ShowType={0} WHERE Id IN({1}) ", ShowType, Ids);
            return base.Execute(sql) > 0;
        }

        /// <summary>
        /// 根据编号删除评论
        /// </summary>
        /// <param name="Ids"></param>
        /// <returns></returns>
        public bool DeleteStuCommentRepository(string Ids)
        {
            string sql = string.Format("UPDATE RB_Stu_CommentDetails SET Status=1 WHERE Id IN({0}) ", Ids);
            return base.Execute(sql) > 0;
        }
    }
}
