﻿
using EduSpider.IRepository;
using EduSpider.IServices;
using EduSpider.Model.Extend;
using EduSpider.Repository;
using EduSpider.Utility.Data;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VTX.FW.Attr;
using VTX.FW.DB;
using VTX.FW.Helper;

namespace EduSpider.Services
{
    /// <summary>
    /// 考试服务实现
    /// </summary>
    public class ExamService : IExamService
    {
        /// <summary>
        /// 帐号仓储接口
        /// </summary>
        [Autowired]
        private IAccountRepository AccountRepository { get; set; }
        /// <summary>
        /// 考试
        /// </summary>
        [Autowired]
        private IExamRepository ExamRepository { get; set; }
        /// <summary>
        /// 考试题目
        /// </summary>
        [Autowired]
        private IExam_QuestionsRepository Exam_QuestionsRepository { get; set; }
        /// <summary>
        /// 考试得分
        /// </summary>
        [Autowired]
        private IExam_ScoreRepository Exam_ScoreRepository { get; set; }
        /// <summary>
        /// 学生
        /// </summary>
        [Autowired]
        private IStudentRepository StudentRepository { get; set; }

        /// <summary>
        /// 获取考试分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Exam_Extend> GetExamPageList(int pageIndex, int pageSize, out long count, RB_Exam_Extend demodel)
        {
            return ExamRepository.GetExamPageList(pageIndex, pageSize, out count, demodel);
        }

        /// <summary>
        /// 获取考试学生列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Exam_Score_Extend> GetExamStuList(RB_Exam_Score_Extend demodel)
        {
            return Exam_ScoreRepository.GetList(demodel);
        }

        /// <summary>
        /// 获取学生考试详情
        /// </summary>
        /// <param name="examId"></param>
        /// <param name="stuId"></param>
        /// <param name="stuUId"></param>
        /// <returns></returns>
        public object GetExamStuScoreInfo(int examId, int stuId, int stuUId)
        {
            if (stuUId > 0) {
                var accountModel = AccountRepository.GetAccountList(new rb_account_hk_Extend() { AccountId = stuUId, AccountType = Utility.Enum.AccountTypeEnum.Student }).FirstOrDefault();
                if (accountModel == null) { return ""; }
                stuId = accountModel.Id;
            }
            var stuModel = StudentRepository.GetEntity(stuId);
            if (stuModel == null) { return ""; }
            var examModel = ExamRepository.GetEntity(examId);
            if (examModel == null) { return ""; }
            //考试题目
            var qlist = Exam_QuestionsRepository.GetList(new RB_Exam_Questions_Extend() { ExamId = examId });
            //考试成绩
            var sExamModel = Exam_ScoreRepository.GetList(new RB_Exam_Score_Extend() { ExamId = examId, StuId = stuId }).FirstOrDefault();
            if (sExamModel != null) {
                sExamModel.ScoreList = JsonHelper.Deserialize<List<ExamQScoreModel>>(sExamModel.Content);
                foreach (var qitem in sExamModel.ScoreList) {
                    qitem.Difficulty = qlist.Where(x => x.Sort == qitem.Sort).FirstOrDefault()?.Difficulty ?? "";
                    qitem.KnowledgePoint = qlist.Where(x => x.Sort == qitem.Sort).FirstOrDefault()?.KnowledgePoint ?? "";
                    qitem.QScore = qlist.Where(x => x.Sort == qitem.Sort).FirstOrDefault()?.Score ?? 0;
                }
            }


            //开始组装数据
            return new
            {
                StuId = stuModel.StudId,
                StuName = stuModel.StudentName,
                examModel.ExamName,
                sExamModel?.TScore,
                sExamModel?.Rank,
                sExamModel?.RankRate,
                ScoreRate = Math.Round((sExamModel?.TScore ?? 0) / (sExamModel?.ExamScore ?? 1), 2, MidpointRounding.AwayFromZero),
                ScoreList = sExamModel?.ScoreList.Select(x => new
                {
                    x.Sort,
                    x.Difficulty,
                    x.KnowledgePoint,
                    x.QScore,
                    x.Score,
                    ScoreRate = Math.Round(x.Score / x.QScore, 2, MidpointRounding.AwayFromZero),
                    AvgScore = Math.Round(x.AvgScore, 6, MidpointRounding.AwayFromZero),
                    AvgScoreRate = Math.Round(x.AvgScore / x.QScore, 2, MidpointRounding.AwayFromZero),
                }),
                ModuleList = sExamModel?.ScoreList.GroupBy(x => new { x.KnowledgePoint }).Take(8).Select(x => new
                {
                    Module = x.Key.KnowledgePoint,
                    Score = x.Sum(y => y.QScore),
                    ScoreRate = Math.Round(x.Sum(y => y.Score) / x.Sum(y => y.QScore), 2, MidpointRounding.AwayFromZero),
                    AvgScoreRate = Math.Round(x.Sum(y => y.AvgScore) / x.Sum(y => y.QScore), 2, MidpointRounding.AwayFromZero),
                }),
                DifficultyList = sExamModel?.ScoreList.GroupBy(x => new { x.Difficulty }).Select(x => new
                {
                    Difficulty = x.Key.Difficulty == "易" ? "简单题" : x.Key.Difficulty == "中" ? "中档题" : "难题",
                    Count = x.Count(),
                    Score = x.Sum(x => x.QScore)
                }),
                DifficultyRateList = sExamModel?.ScoreList.GroupBy(x => new { x.Difficulty }).Select(x => new
                {
                    Difficulty = x.Key.Difficulty == "易" ? "简单题" : x.Key.Difficulty == "中" ? "中档题" : "难题",
                    ScoreRate = Math.Round(x.Sum(y => y.Score) / x.Sum(y => y.QScore), 2, MidpointRounding.AwayFromZero),
                    AvgScoreRate = Math.Round(x.Sum(y => y.AvgScore) / x.Sum(y => y.QScore), 2, MidpointRounding.AwayFromZero),
                })
            };
        }

        /// <summary>
        /// 删除考试
        /// </summary>
        /// <param name="examId"></param>
        /// <param name="baseUserId"></param>
        /// <returns></returns>
        public string DelExamInfo(int examId, int baseUserId)
        {
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Exam_Extend.Status), 1},
                { nameof(RB_Exam_Extend.UpdateBy), baseUserId},
                { nameof(RB_Exam_Extend.UpdateTime), DateTime.Now},
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                     FiledName = nameof(RB_Exam_Extend.ExamId),
                      FiledValue = examId,
                       OperatorEnum =OperatorEnum.Equal
                }
            };
            bool flag = ExamRepository.Update(keyValues, wheres);
            return flag ? "" : "出错了，请联系管理员";
        }

        /// <summary>
        /// 导入考试成绩
        /// </summary>
        /// <param name="path_server"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        public string ImportExcelForStuExamScore(string path_server,int courseId, string examName, int userId)
        {
            var umodel = AccountRepository.GetAccountList(new Model.Extend.rb_account_hk_Extend() { Id = userId, AccountType =  Utility.Enum.AccountTypeEnum.Teacher }).FirstOrDefault();
            if (umodel == null || umodel.Status == Utility.Enum.DateStateEnum.Delete || umodel.AccountType != Utility.Enum.AccountTypeEnum.Teacher) { return "没有权限操作"; }
            var EQlist = StuExamScoreHelper.GetStuExamScoreData(path_server, out List<StuScoreModel> StuList);
            if (EQlist.Any())
            {
                var AvgList = StuList.Where(x => x.Name == "平均分").ToList();
                StuList = StuList.Where(x => x.Name != "平均分" && !string.IsNullOrWhiteSpace(x.Name)).ToList();
                //根据学生姓名 查询所有的学生账号
                string StuNames = "'" + string.Join("','", StuList.Select(x => x.Name).Distinct()) + "'";
                var sList = StudentRepository.GetListForStuName(StuNames);

                //插入考试
                int ExamId = ExamRepository.Insert(new Model.Entity.RB_Exam()
                {
                    ExamId = 0,
                    CourseId = courseId,
                    ExamName = examName,
                    CreateBy = userId,
                    CreateTime = DateTime.Now,
                    Status = 0
                });
                if (ExamId > 0) {
                    List<Model.Entity.RB_Exam_Questions> InsertEQ = new();
                    //开始插入题目
                    foreach (var item in EQlist)
                    {
                        InsertEQ.Add(new Model.Entity.RB_Exam_Questions()
                        {
                            Id = 0,
                            ExamId = ExamId,
                            Difficulty = item.Difficulty,
                            KnowledgePoint = item.KnowledgePoint,
                            Score = item.Score,
                            Sort = item.Id
                        });
                    }
                    Exam_QuestionsRepository.BatchInsert(InsertEQ);

                    decimal ExamScore = InsertEQ.Sum(x => x.Score);
                    List<Model.Entity.RB_Exam_Score> InsertScore = new();
                    foreach (var Name in StuList.Select(x => x.Name).Distinct()) {
                        var clist = StuList.Where(x => x.Name == Name).ToList();
                        var stuModel = sList.Where(x => x.StudentName == Name).FirstOrDefault();
                        InsertScore.Add(new Model.Entity.RB_Exam_Score()
                        {
                            Id = 0,
                            ExamId = ExamId,
                            StuId = stuModel?.StudId ?? 0,//匹配学生失败  可能要在后台给与提示， 重新导入
                            StuUId = stuModel?.StudentUid ?? 0,
                            StuName = Name,
                            Content = JsonHelper.Serialize(clist.Where(x => x.Id > 0).Select(x => new
                            {
                                Sort = x.Id,
                                x.Score,
                                AvgScore = Math.Round(AvgList.Where(y => y.Id == x.Id).FirstOrDefault()?.Score ?? 0, 6, MidpointRounding.AwayFromZero)
                            })),
                            TScore = clist.Where(x => x.Id == -1).FirstOrDefault()?.Score ?? 0,
                            Rank = Convert.ToInt32(clist.Where(x => x.Id == -2).FirstOrDefault()?.Score ?? 0),
                            RankRate = clist.Where(x => x.Id == -3).FirstOrDefault()?.Score ?? 0,
                            ExamScore = ExamScore
                        });
                    }
                    //InsertScore = InsertScore.Where(x => x.StuId > 0).ToList();//暂时只插入匹配到学生的
                    Exam_ScoreRepository.BatchInsert(InsertScore);
                }

                return "";
            }
            else
            {
                return "模板匹配失败";
            }
        }

        /// <summary>
        /// 取消备份
        /// </summary>
        /// <param name="path_server"></param>
        /// <param name="courseId"></param>
        /// <param name="examName"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        public string ImportExcelForStuExamScore_V2(string path_server, int courseId, string examName, int userId)
        {
            var umodel = AccountRepository.GetAccountList(new Model.Extend.rb_account_hk_Extend() { Id = userId }).FirstOrDefault();
            if (umodel == null || umodel.Status == Utility.Enum.DateStateEnum.Delete || umodel.AccountType != Utility.Enum.AccountTypeEnum.Teacher) { return "没有权限操作"; }
            var EQlist = StuExamScoreHelper.GetStuExamScoreData(path_server, out List<StuScoreModel> StuList);
            if (EQlist.Any())
            {
                var AvgList = StuList.Where(x => x.Name == "平均分").ToList();
                StuList = StuList.Where(x => x.Name != "平均分" && !string.IsNullOrWhiteSpace(x.Name)).ToList();
                //根据学生姓名 查询所有的学生账号
                string StuNames = "'" + string.Join("','", StuList.Select(x => x.Name).Distinct()) + "'";
                var sList = StudentRepository.GetListForStuName(StuNames);

                //插入考试
                int ExamId = ExamRepository.Insert(new Model.Entity.RB_Exam()
                {
                    ExamId = 0,
                    CourseId = courseId,
                    ExamName = examName,
                    CreateBy = userId,
                    CreateTime = DateTime.Now,
                    Status = 0
                });
                if (ExamId > 0)
                {
                    List<Model.Entity.RB_Exam_Questions> InsertEQ = new();
                    //开始插入题目
                    foreach (var item in EQlist)
                    {
                        InsertEQ.Add(new Model.Entity.RB_Exam_Questions()
                        {
                            Id = 0,
                            ExamId = ExamId,
                            Difficulty = item.Difficulty,
                            KnowledgePoint = item.KnowledgePoint,
                            Score = item.Score,
                            Sort = item.Id
                        });
                    }
                    Exam_QuestionsRepository.BatchInsert(InsertEQ);

                    List<Model.Entity.RB_Exam_Score> InsertScore = new();
                    //开始插入得分
                    foreach (var item in StuList)
                    {
                        var stuModel = sList.Where(x => x.StudentName == item.Name).FirstOrDefault();
                        InsertScore.Add(new Model.Entity.RB_Exam_Score()
                        {
                            Id = 0,
                            ExamId = ExamId,
                            //Sort = item.Id,
                            StuId = stuModel?.StudId ?? 0,//=0表示未匹配上 暂时=0处理
                            //Score = item.Score,
                            StuName = item.Name
                        });
                    }
                    Exam_ScoreRepository.BatchInsert(InsertScore);
                }

                return "";
            }
            else
            {
                return "模板匹配失败";
            }
        }
    }
}
