﻿using EduSpider.Model.Entity;
using System;
using System.Collections.Generic;
using VTX.FW.Attr;

namespace EduSpider.Model.Extend
{
    /// <summary>
    /// 考试分数扩展
    /// </summary>
    public class RB_Exam_Score_Extend : RB_Exam_Score
    {

        /// <summary>
        /// 考试名称
        /// </summary>
        public string ExamName { get; set; }

        public List<ExamQScoreModel> ScoreList { get; set; }

        /// <summary>
        /// 考试导入时间
        /// </summary>
        public DateTime ExamCreateTime { get; set; }
    }

    /// <summary>
    /// 学生单项分数
    /// </summary>
    public class ExamQScoreModel
    {
        /// <summary>
        /// 题号
        /// </summary>
        public int Sort { get; set; }
        /// <summary>
        /// 得分
        /// </summary>
        public decimal Score { get; set; }
        /// <summary>
        /// 平均得分
        /// </summary>
        public decimal AvgScore { get; set; }

        /// <summary>
        /// 难度
        /// </summary>
        public string Difficulty { get; set; }

        /// <summary>
        /// 知识点
        /// </summary>
        public string KnowledgePoint { get; set; }

        /// <summary>
        /// 题目分数
        /// </summary>
        public decimal QScore { get; set; }
    }
}
