﻿using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Model.Query;
using EduSpider.Repository.Base;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VTX.FW.DB.Dapper;

namespace EduSpider.Repository
{
    /// <summary>
    /// 课程学员关联仓储层
    /// </summary>
    public class CourseStudentRepository : BaseRepository<RB_Course_Student>, ICourseStudentRepository
    {
        /// <summary>
        /// 批量新增课程学员
        /// </summary>
        /// <param name="courses"></param>
        /// <returns></returns>
        public bool BatchSetCourseStudentRepository(List<RB_Course_Student> courses)
        {
            bool flag;
            flag = base.BatchInsert(courses, isReplace: true);
            return flag;
        }

        /// <summary>
        /// 跟进查询条件获取课程学员列表
        /// </summary>
        /// <param name="courseQuery"></param>
        /// <returns></returns>
        public List<RB_Course_Student_Extend> GetCourseStudentListRepository(CourseQuery query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new();
            builder.AppendFormat(@"
SELECT A.*,B.courseName,B.teacherId,B.teacherName,B.teacherLogo,B.CoverImg,B.courseStatus,B.completeNum,B.totalClassNum
FROM RB_Course_Student AS A INNER JOIN  RB_Course AS B ON A.courseId=B.courseId
WHERE 1=1
");
            if (query != null)
            {
           
                if (query.CourseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Course_Student.courseId), query.CourseId);
                }
                if (!string.IsNullOrWhiteSpace(query.StuIds))
                {
                    builder.AppendFormat(" AND A.{0} IN({1}) ", nameof(RB_Course_Student.id), query.StuIds);
                }
            }
            builder.AppendFormat(" ORDER BY A.courseId DESC ");
            return base.Get<RB_Course_Student_Extend>(builder.ToString(), parameters).ToList();
        }
    }
}
