﻿using EduSpider.IRepository;
using EduSpider.Model.Entity;
using EduSpider.Model.Query;
using EduSpider.Repository.Base;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EduSpider.Repository
{
    /// <summary>
    /// 作业仓储层实现
    /// </summary>
    public class HomeWorkRepository : BaseRepository<RB_HomeWork>, IHomeWorkRepository
    {
        /// <summary>
        /// 批量添加家庭作业
        /// </summary>
        /// <param name="homeWorks"></param>
        /// <returns></returns>
        public bool BatchSetHomeWorkRepository(List<RB_HomeWork> homeWorks)
        {
            bool flag;
            flag = base.BatchInsert(homeWorks, isReplace: true);
            return flag;
        }

        /// <summary>
        /// 获取课程作业列表
        /// </summary>
        /// <param name="homeWorks"></param>
        /// <returns></returns>
        public List<RB_HomeWork> GetCourseHomeWorkListRepository(CourseQuery query)
        {
            StringBuilder builder = new();
            builder.AppendFormat(@"
SELECT A.*
FROM RB_HomeWork AS A
WHERE 1=1
");
            if (query != null)
            {
                if (query.CourseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_HomeWork.Course_id), query.CourseId);
                }
                if (query.HomeWorkId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_HomeWork.Homework_id), query.HomeWorkId);
                }
            }
            return Get<RB_HomeWork>(builder.ToString()).ToList();
        }
    }
}
