﻿using NPOI.HSSF.UserModel;
using NPOI.SS.Formula.Eval;
using NPOI.SS.UserModel;
using NPOI.SS.Util;
using NPOI.XSSF.UserModel;
using System;
using System.Data;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using VTX.FW.Helper;

namespace EduSpider.Utility
{
    /// <summary>
    /// npoi帮助类
    /// </summary>
    public class NPOIHelper
    {
        #region 从datatable中将数据导出到excel
        /// <summary>
        /// DataTable导出到Excel的MemoryStream
        /// </summary>
        /// <param name="dtSource">源DataTable</param>
        /// <param name="strHeaderText">表头文本</param>
        [Obsolete]
        static MemoryStream ExportDataTable(DataTable dtSource, String strHeaderText)
        {
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.CreateSheet() as HSSFSheet;

            HSSFCellStyle dateStyle = workbook.CreateCellStyle() as HSSFCellStyle;
            HSSFDataFormat format = workbook.CreateDataFormat() as HSSFDataFormat;
            dateStyle.DataFormat = format.GetFormat("yyyy-mm-dd");

            //取得列宽
            int[] arrColWidth = new int[dtSource.Columns.Count];
            foreach (DataColumn item in dtSource.Columns)
            {
                arrColWidth[item.Ordinal] = Encoding.GetEncoding(936).GetBytes(item.ColumnName.ToString()).Length;
            }
            for (int i = 0; i < dtSource.Rows.Count; i++)
            {
                for (int j = 0; j < dtSource.Columns.Count; j++)
                {
                    int intTemp = Encoding.GetEncoding(936).GetBytes(dtSource.Rows[i][j].ToString()).Length;
                    if (intTemp > arrColWidth[j])
                    {
                        arrColWidth[j] = intTemp;
                    }
                }
            }
            int rowIndex = 0;

            foreach (DataRow row in dtSource.Rows)
            {
                #region 新建表，填充表头，填充列头，样式

                if (rowIndex == 65535 || rowIndex == 0)
                {
                    if (rowIndex != 0)
                    {
                        sheet = workbook.CreateSheet() as HSSFSheet;
                    }
                    #region 表头及样式
                    {
                        HSSFRow headerRow = sheet.CreateRow(0) as HSSFRow;
                        headerRow.HeightInPoints = 25;
                        headerRow.CreateCell(0).SetCellValue(strHeaderText);

                        HSSFCellStyle headStyle = workbook.CreateCellStyle() as HSSFCellStyle;
                        headStyle.Alignment = NPOI.SS.UserModel.HorizontalAlignment.Center;
                        HSSFFont font = workbook.CreateFont() as HSSFFont;
                        font.FontHeightInPoints = 20;
                        font.Boldweight = 700;
                        headStyle.SetFont(font);
                        headerRow.GetCell(0).CellStyle = headStyle;
                        sheet.AddMergedRegion(new CellRangeAddress(0, 0, 0, dtSource.Columns.Count - 1));
                    }

                    #endregion


                    #region 列头及样式

                    {
                        HSSFRow headerRow = sheet.CreateRow(1) as HSSFRow;


                        HSSFCellStyle headStyle = workbook.CreateCellStyle() as HSSFCellStyle;
                        headStyle.Alignment = NPOI.SS.UserModel.HorizontalAlignment.Center;
                        HSSFFont font = workbook.CreateFont() as HSSFFont;
                        font.FontHeightInPoints = 10;
                        font.Boldweight = 700;
                        headStyle.SetFont(font);


                        foreach (DataColumn column in dtSource.Columns)
                        {
                            headerRow.CreateCell(column.Ordinal).SetCellValue(column.ColumnName);
                            headerRow.GetCell(column.Ordinal).CellStyle = headStyle;

                            //设置列宽
                            sheet.SetColumnWidth(column.Ordinal, (arrColWidth[column.Ordinal] + 1) * 256);

                        }
                        //headerRow.Dispose();
                    }

                    #endregion

                    rowIndex = 2;
                }

                #endregion

                #region 填充内容

                HSSFRow dataRow = sheet.CreateRow(rowIndex) as HSSFRow;
                foreach (DataColumn column in dtSource.Columns)
                {
                    HSSFCell newCell = dataRow.CreateCell(column.Ordinal) as HSSFCell;

                    String drValue = row[column].ToString();

                    switch (column.DataType.ToString())
                    {
                        case "System.String": //字符串类型
                            double result;
                            if (IsNumeric(drValue, out result))
                            {

                                double.TryParse(drValue, out result);
                                newCell.SetCellValue(result);
                                break;
                            }
                            else
                            {
                                newCell.SetCellValue(drValue);
                                break;
                            }

                        case "System.DateTime": //日期类型
                            DateTime dateV;
                            DateTime.TryParse(drValue, out dateV);
                            newCell.SetCellValue(dateV);

                            newCell.CellStyle = dateStyle; //格式化显示
                            break;
                        case "System.Boolean": //布尔型
                            bool boolV = false;
                            bool.TryParse(drValue, out boolV);
                            newCell.SetCellValue(boolV);
                            break;
                        case "System.Int16": //整型
                        case "System.Int32":
                        case "System.Int64":
                        case "System.Byte":
                            int intV = 0;
                            int.TryParse(drValue, out intV);
                            newCell.SetCellValue(intV);
                            break;
                        case "System.Decimal": //浮点型
                        case "System.Double":
                            double doubV = 0;
                            double.TryParse(drValue, out doubV);
                            newCell.SetCellValue(doubV);
                            break;
                        case "System.DBNull": //空值处理
                            newCell.SetCellValue("");
                            break;
                        default:
                            newCell.SetCellValue("");
                            break;
                    }

                }

                #endregion

                rowIndex++;
            }
            using MemoryStream ms = new MemoryStream();
            workbook.Write(ms);
            ms.Flush();
            ms.Position = 0;
            return ms;
        }

        /// <summary>
        /// DataTable导出到Excel的MemoryStream
        /// </summary>
        /// <param name="dtSource">源DataTable</param>
        /// <param name="strHeaderText">表头文本</param>
        /// <param name="fs">文件流</param>
        [Obsolete]
        static void ExportDataTableI(DataTable dtSource, String strHeaderText, FileStream fs)
        {
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.CreateSheet() as XSSFSheet;

            #region 右击文件 属性信息

            //{
            //    DocumentSummaryInformation dsi = PropertySetFactory.CreateDocumentSummaryInformation();
            //    dsi.Company = "http://www.yongfa365.com/";
            //    workbook.DocumentSummaryInformation = dsi;

            //    SummaryInformation si = PropertySetFactory.CreateSummaryInformation();
            //    si.Author = "柳永法"; //填加xls文件作者信息
            //    si.ApplicationName = "NPOI测试程序"; //填加xls文件创建程序信息
            //    si.LastAuthor = "柳永法2"; //填加xls文件最后保存者信息
            //    si.Comments = "说明信息"; //填加xls文件作者信息
            //    si.Title = "NPOI测试"; //填加xls文件标题信息
            //    si.Subject = "NPOI测试Demo"; //填加文件主题信息
            //    si.CreateDateTime = DateTime.Now;
            //    workbook.SummaryInformation = si;
            //}

            #endregion

            XSSFCellStyle dateStyle = workbook.CreateCellStyle() as XSSFCellStyle;
            XSSFDataFormat format = workbook.CreateDataFormat() as XSSFDataFormat;
            dateStyle.DataFormat = format.GetFormat("yyyy-mm-dd");

            //取得列宽
            int[] arrColWidth = new int[dtSource.Columns.Count];
            foreach (DataColumn item in dtSource.Columns)
            {
                arrColWidth[item.Ordinal] = Encoding.GetEncoding(936).GetBytes(item.ColumnName.ToString()).Length;
            }
            for (int i = 0; i < dtSource.Rows.Count; i++)
            {
                for (int j = 0; j < dtSource.Columns.Count; j++)
                {
                    int intTemp = Encoding.GetEncoding(936).GetBytes(dtSource.Rows[i][j].ToString()).Length;
                    if (intTemp > arrColWidth[j])
                    {
                        arrColWidth[j] = intTemp;
                    }
                }
            }
            int rowIndex = 0;

            foreach (DataRow row in dtSource.Rows)
            {
                #region 新建表，填充表头，填充列头，样式

                if (rowIndex == 0)
                {
                    #region 表头及样式
                    //{
                    //    XSSFRow headerRow = sheet.CreateRow(0) as XSSFRow;
                    //    headerRow.HeightInPoints = 25;
                    //    headerRow.CreateCell(0).SetCellValue(strHeaderText);

                    //    XSSFCellStyle headStyle = workbook.CreateCellStyle() as XSSFCellStyle;
                    //    headStyle.Alignment = NPOI.SS.UserModel.HorizontalAlignment.Center;
                    //    XSSFFont font = workbook.CreateFont() as XSSFFont;
                    //    font.FontHeightInPoints = 20;
                    //    font.Boldweight = 700;
                    //    headStyle.SetFont(font);

                    //    headerRow.GetCell(0).CellStyle = headStyle;

                    //    //sheet.AddMergedRegion(new Region(0, 0, 0, dtSource.Columns.Count - 1));
                    //    //headerRow.Dispose();
                    //}

                    #endregion


                    #region 列头及样式

                    {
                        XSSFRow headerRow = sheet.CreateRow(0) as XSSFRow;


                        XSSFCellStyle headStyle = workbook.CreateCellStyle() as XSSFCellStyle;
                        headStyle.Alignment = NPOI.SS.UserModel.HorizontalAlignment.Center;
                        XSSFFont font = workbook.CreateFont() as XSSFFont;
                        font.FontHeightInPoints = 10;
                        font.Boldweight = 700;
                        headStyle.SetFont(font);


                        foreach (DataColumn column in dtSource.Columns)
                        {
                            headerRow.CreateCell(column.Ordinal).SetCellValue(column.ColumnName);
                            headerRow.GetCell(column.Ordinal).CellStyle = headStyle;

                            //设置列宽
                            sheet.SetColumnWidth(column.Ordinal, (arrColWidth[column.Ordinal] + 1) * 256);

                        }
                        //headerRow.Dispose();
                    }

                    #endregion

                    rowIndex = 1;
                }

                #endregion

                #region 填充内容

                XSSFRow dataRow = sheet.CreateRow(rowIndex) as XSSFRow;
                foreach (DataColumn column in dtSource.Columns)
                {
                    XSSFCell newCell = dataRow.CreateCell(column.Ordinal) as XSSFCell;

                    String drValue = row[column].ToString();

                    switch (column.DataType.ToString())
                    {
                        case "System.String": //字符串类型
                            double result;
                            if (IsNumeric(drValue, out result))
                            {

                                double.TryParse(drValue, out result);
                                newCell.SetCellValue(result);
                                break;
                            }
                            else
                            {
                                newCell.SetCellValue(drValue);
                                break;
                            }

                        case "System.DateTime": //日期类型
                            DateTime dateV;
                            DateTime.TryParse(drValue, out dateV);
                            newCell.SetCellValue(dateV);

                            newCell.CellStyle = dateStyle; //格式化显示
                            break;
                        case "System.Boolean": //布尔型
                            bool boolV = false;
                            bool.TryParse(drValue, out boolV);
                            newCell.SetCellValue(boolV);
                            break;
                        case "System.Int16": //整型
                        case "System.Int32":
                        case "System.Int64":
                        case "System.Byte":
                            int intV = 0;
                            int.TryParse(drValue, out intV);
                            newCell.SetCellValue(intV);
                            break;
                        case "System.Decimal": //浮点型
                        case "System.Double":
                            double doubV = 0;
                            double.TryParse(drValue, out doubV);
                            newCell.SetCellValue(doubV);
                            break;
                        case "System.DBNull": //空值处理
                            newCell.SetCellValue("");
                            break;
                        default:
                            newCell.SetCellValue("");
                            break;
                    }

                }

                #endregion

                rowIndex++;
            }
            workbook.Write(fs);
            fs.Close();
        }

        /// <summary>
        /// DataTable导出到Excel文件
        /// </summary>
        /// <param name="dtSource">源DataTable</param>
        /// <param name="strHeaderText">表头文本</param>
        /// <param name="strFileName">保存位置(路径+文件名)</param>
        [Obsolete]
        public static void ExportDataTableToExcel(DataTable dtSource, String strHeaderText, String strFileName)
        {
            String[] temp = strFileName.Split('.');
            if (temp[^1] == "xls" && dtSource.Columns.Count < 256 && dtSource.Rows.Count < 65536)
            {
                using MemoryStream ms = ExportDataTable(dtSource, strHeaderText);
                using FileStream fs = new FileStream(strFileName, FileMode.Create, FileAccess.Write);
                byte[] data = ms.ToArray();
                fs.Write(data, 0, data.Length);
                fs.Flush();
            }
            else
            {
                if (temp[^1] == "xls")
                    strFileName += "x";
                using FileStream fs = new FileStream(strFileName, FileMode.Create, FileAccess.Write);
                ExportDataTableI(dtSource, strHeaderText, fs);
            }
        }
        #endregion

        #region 从excel文件中将数据导出到datatable

        /// <summary>
        /// 读取excel
        /// </summary>
        /// <param name="strFileName">excel文件路径</param>
        /// <param name="SheetIndex">需要导出的sheet序号</param>
        /// <param name="HeaderRowIndex">列头所在行号，-1表示没有列头</param>
        /// <param name="needHeader">列头</param>
        /// <returns></returns>
        public static DataTable ImportExcelToDatatable(String strFileName, int SheetIndex, int HeaderRowIndex, bool needHeader)
        {
            IWorkbook wb;
            using (FileStream file = new FileStream(strFileName, FileMode.Open, FileAccess.Read))
            {
                wb = WorkbookFactory.Create(file);
            }
            ISheet sheet = wb.GetSheetAt(SheetIndex);
            DataTable table = ImportDataTable(sheet, HeaderRowIndex, needHeader);
            return table;
        }

        /// <summary>
        /// 将制定sheet中的数据导出到datatable中
        /// </summary>
        /// <param name="sheet">需要导出的sheet</param>
        /// <param name="HeaderRowIndex">列头所在行号，-1表示没有列头</param>
        /// <param name="needHeader">是否导出表头</param>
        /// <returns></returns>
        static DataTable ImportDataTable(ISheet sheet, int HeaderRowIndex, bool needHeader)
        {
            DataTable table = new DataTable();
            IRow headerRow;
            int cellCount;
            try
            {
                if (HeaderRowIndex < 0 || !needHeader)
                {
                    headerRow = sheet.GetRow(0);
                    cellCount = headerRow.LastCellNum;

                    for (int i = headerRow.FirstCellNum; i <= cellCount; i++)
                    {
                        DataColumn column = new DataColumn(Convert.ToString(i));
                        table.Columns.Add(column);
                    }
                }
                else
                {
                    headerRow = sheet.GetRow(HeaderRowIndex);
                    cellCount = headerRow.LastCellNum;

                    for (int i = headerRow.FirstCellNum; i <= cellCount; i++)
                    {
                        if (headerRow.GetCell(i) == null)
                        {
                            if (table.Columns.IndexOf(Convert.ToString(i)) > 0)
                            {
                                DataColumn column = new DataColumn(Convert.ToString("重复列名" + i));
                                table.Columns.Add(column);
                            }
                            else
                            {
                                DataColumn column = new DataColumn(Convert.ToString(i));
                                table.Columns.Add(column);
                            }

                        }
                        else if (table.Columns.IndexOf(headerRow.GetCell(i).ToString()) > 0)
                        {
                            DataColumn column = new DataColumn(Convert.ToString("重复列名" + i));
                            table.Columns.Add(column);
                        }
                        else
                        {
                            DataColumn column = new DataColumn(headerRow.GetCell(i).ToString());
                            table.Columns.Add(column);
                        }
                    }
                }
                int rowCount = sheet.LastRowNum;
                for (int i = (HeaderRowIndex + 1); i <= sheet.LastRowNum; i++)
                {
                    try
                    {
                        IRow row;
                        if (sheet.GetRow(i) == null)
                        {
                            row = sheet.CreateRow(i);
                        }
                        else
                        {
                            row = sheet.GetRow(i);
                        }

                        DataRow dataRow = table.NewRow();

                        for (int j = row.FirstCellNum; j <= cellCount; j++)
                        {
                            try
                            {
                                if (row.GetCell(j) != null)
                                {
                                    switch (row.GetCell(j).CellType)
                                    {
                                        case CellType.String:
                                            String str = row.GetCell(j).StringCellValue;
                                            if (str != null && str.Length > 0)
                                            {
                                                dataRow[j] = str.ToString();
                                            }
                                            else
                                            {
                                                dataRow[j] = null;
                                            }
                                            break;
                                        case CellType.Numeric:
                                            if (DateUtil.IsCellDateFormatted(row.GetCell(j)))
                                            {
                                                dataRow[j] = DateTime.FromOADate(row.GetCell(j).NumericCellValue);
                                            }
                                            else
                                            {
                                                dataRow[j] = Convert.ToDouble(row.GetCell(j).NumericCellValue);
                                            }
                                            break;
                                        case CellType.Boolean:
                                            dataRow[j] = Convert.ToString(row.GetCell(j).BooleanCellValue);
                                            break;
                                        case CellType.Error:
                                            dataRow[j] = ErrorEval.GetText(row.GetCell(j).ErrorCellValue);
                                            break;
                                        case CellType.Formula:
                                            switch (row.GetCell(j).CachedFormulaResultType)
                                            {
                                                case CellType.String:
                                                    String strFORMULA = row.GetCell(j).StringCellValue;
                                                    if (strFORMULA != null && strFORMULA.Length > 0)
                                                    {
                                                        dataRow[j] = strFORMULA.ToString();
                                                    }
                                                    else
                                                    {
                                                        dataRow[j] = null;
                                                    }
                                                    break;
                                                case CellType.Numeric:
                                                    dataRow[j] = Convert.ToString(row.GetCell(j).NumericCellValue);
                                                    break;
                                                case CellType.Boolean:
                                                    dataRow[j] = Convert.ToString(row.GetCell(j).BooleanCellValue);
                                                    break;
                                                case CellType.Error:
                                                    dataRow[j] = ErrorEval.GetText(row.GetCell(j).ErrorCellValue);
                                                    break;
                                                default:
                                                    dataRow[j] = "";
                                                    break;
                                            }
                                            break;
                                        default:
                                            dataRow[j] = "";
                                            break;
                                    }
                                }
                            }
                            catch (Exception exception)
                            {
                                LogHelper.WriteError("ImportDataTable", "ImportDataTable_1", exception);
                            }
                        }
                        table.Rows.Add(dataRow);
                    }
                    catch (Exception exception)
                    {
                        LogHelper.WriteError("ImportDataTable", "ImportDataTable_2", exception);
                    }
                }
            }
            catch (Exception exception)
            {
                LogHelper.WriteError("ImportDataTable", "ImportDataTable_3", exception);
            }
            return table;
        }

        /// <summary>
        /// Excel转DataSet
        /// </summary>
        /// <param name="excelPath"></param>
        /// <returns></returns>
        public static DataSet ExcelToDataSet(string excelPath)
        {
            return ExcelToDataSet(excelPath, true, out int sheetCount);
        }

        /// <summary>
        /// Excel转DataSet
        /// </summary>
        /// <param name="excelPath"></param>
        /// <param name="firstRowAsHeader"></param>
        /// <param name="sheetCount"></param>
        /// <returns></returns>
        static DataSet ExcelToDataSet(string excelPath, bool firstRowAsHeader, out int sheetCount)
        {
            using DataSet ds = new DataSet();
            using FileStream fileStream = new FileStream(excelPath, FileMode.Open, FileAccess.Read);
            string extFile = Path.GetExtension(excelPath).ToLower();
            IWorkbook workbook;
            if (extFile.Equals(".xls"))
            {
                workbook = new HSSFWorkbook(fileStream);
                HSSFFormulaEvaluator evaluator = new HSSFFormulaEvaluator(workbook);
                sheetCount = workbook.NumberOfSheets;
                for (int i = 0; i < sheetCount; ++i)
                {
                    HSSFSheet sheet = workbook.GetSheetAt(i) as HSSFSheet;
                    DataTable dt = ImportDataTable(sheet, 0, firstRowAsHeader);
                    dt.TableName = workbook.GetSheetName(i);
                    ds.Tables.Add(dt);
                }
                return ds;
            }
            else
            {
                workbook = new XSSFWorkbook(fileStream);
                XSSFFormulaEvaluator evaluator = new XSSFFormulaEvaluator(workbook);
                sheetCount = workbook.NumberOfSheets;
                for (int i = 0; i < sheetCount; ++i)
                {
                    XSSFSheet sheet = workbook.GetSheetAt(i) as XSSFSheet;
                    DataTable dt = ImportDataTable(sheet, 0, firstRowAsHeader);
                    dt.TableName = workbook.GetSheetName(i);
                    ds.Tables.Add(dt);
                }
                return ds;
            }
        }

        #endregion

        /// <summary>
        /// 判断是否为数字
        /// </summary>
        /// <param name="message"></param>
        /// <param name="result"></param>
        /// <returns></returns>
        public static bool IsNumeric(String message, out double result)
        {
            Regex rex = new Regex(@"^[-]?\d+[.]?\d*$");
            result = -1;
            if (rex.IsMatch(message))
            {
                result = double.Parse(message);
                return true;
            }
            else
                return false;

        }

        /// <summary>
        /// excel 指定行插入数据
        /// </summary>
        /// <param name="dtSource"></param>
        /// <param name="SheetName"></param>
        /// <param name="Path"></param>
        /// <param name="NewPath"></param>
        /// <param name="rowIndex"></param>
        /// <param name="FontName"></param>
        /// <param name="FontHeight"></param>
        /// <param name="height"></param>
        public static void ExportInsert(DataTable dtSource, string SheetName, string Path, string NewPath, int rowIndex = 0, string FontName = "宋体", double FontHeight = 0, short height = 0)
        {
            FileStream file = new FileStream(Path, FileMode.Open, FileAccess.Read);
            XSSFWorkbook workbook = new XSSFWorkbook(file);
            XSSFSheet sheet = workbook.GetSheet(SheetName) as XSSFSheet;

            foreach (DataRow row in dtSource.Rows)
            {
                #region 填充内容

                XSSFRow dataRow = sheet.CreateRow(rowIndex) as XSSFRow;
                if (height > 0)
                {
                    dataRow.Height = height;
                }
                foreach (DataColumn column in dtSource.Columns)
                {
                    XSSFCell newCell = dataRow.CreateCell(column.Ordinal) as XSSFCell;
                    ICellStyle style = workbook.CreateCellStyle();
                    style.WrapText = true;//自动换行
                    IFont font = workbook.CreateFont();
                    font.FontName = FontName;
                    if (FontHeight > 0)
                    {
                        font.FontHeight = FontHeight;
                    }
                    style.SetFont(font);
                    style.Alignment = HorizontalAlignment.Center;
                    newCell.CellStyle = style;
                    String drValue = row[column].ToString();

                    newCell.SetCellValue(drValue);
                }

                #endregion

                rowIndex++;
            }
            FileStream out1 = new FileStream(NewPath, FileMode.Create);
            workbook.Write(out1);
            workbook.Close();
            out1.Close();
        }

        /// <summary>
        /// 测试插入数据  月度考勤专用
        /// </summary>
        /// <param name="dtSource"></param>
        /// <param name="SheetName"></param>
        /// <param name="Path"></param>
        /// <param name="NewPath"></param>
        /// <param name="rowIndex"></param>
        /// <param name="FontName"></param>
        /// <param name="FontHeight"></param>
        /// <param name="height"></param>
        public static void ExportInsertAndMergeCells(DataTable dtSource, string SheetName, string Path, string NewPath, int rowIndex = 0, string FontName = "宋体", double FontHeight = 0, short height = 0)
        {
            FileStream file = new FileStream(Path, FileMode.Open, FileAccess.Read);
            XSSFWorkbook workbook = new XSSFWorkbook(file);
            XSSFSheet sheet = workbook.GetSheet(SheetName) as XSSFSheet;
            string OldDepStr = "";
            int startNum = rowIndex;
            int EndNum = dtSource.Rows.Count + rowIndex;
            foreach (DataRow row in dtSource.Rows)
            {
                #region 填充内容

                XSSFRow dataRow = sheet.CreateRow(rowIndex) as XSSFRow;
                if (height > 0)
                {
                    dataRow.Height = height;
                }
                foreach (DataColumn column in dtSource.Columns)
                {
                    XSSFCell newCell = dataRow.CreateCell(column.Ordinal) as XSSFCell;
                    ICellStyle style = workbook.CreateCellStyle();
                    style.WrapText = true;//自动换行
                    IFont font = workbook.CreateFont();
                    font.FontName = FontName;
                    if (FontHeight > 0)
                    {
                        font.FontHeight = FontHeight;
                    }
                    style.SetFont(font);
                    style.Alignment = HorizontalAlignment.Center;
                    style.VerticalAlignment = NPOI.SS.UserModel.VerticalAlignment.Center;
                    newCell.CellStyle = style;
                    String drValue = row[column].ToString();
                    newCell.SetCellValue(drValue);
                }

                #endregion
                //合并单元格
                if (row["部门"].ToString() != OldDepStr)
                {
                    OldDepStr = row["部门"].ToString();
                    if (OldDepStr == "")
                    {
                        var region = new CellRangeAddress(startNum, rowIndex - 1, 2, 2);
                        sheet.AddMergedRegion(region);
                        startNum = rowIndex;
                    }
                    else
                    {
                        if (startNum != rowIndex)
                        {
                            if (OldDepStr != "")
                            {
                                var region = new CellRangeAddress(startNum, rowIndex - 1, 2, 2);
                                sheet.AddMergedRegion(region);
                            }
                            else
                            {
                                startNum = rowIndex + 1;
                            }
                            startNum = rowIndex;
                        }
                    }
                }
                else
                {
                    if (OldDepStr == "")
                    {
                        startNum = rowIndex + 1;
                    }
                }
                rowIndex++;
                //最后一条数据
                if (EndNum == rowIndex && startNum != rowIndex)
                {
                    var region = new CellRangeAddress(startNum, rowIndex - 1, 2, 2);
                    sheet.AddMergedRegion(region);
                }
            }
            FileStream out1 = new FileStream(NewPath, FileMode.Create);
            workbook.Write(out1);
            workbook.Close();
            out1.Close();
        }


        /// <summary>
        /// excel 指定行插入数据(客户线索专用)
        /// </summary>
        /// <param name="dtSource"></param>
        /// <param name="SheetName"></param>
        /// <param name="Path"></param>
        /// <param name="NewPath"></param>
        /// <param name="rowIndex"></param>
        public static void CustomerExportInsert(DataTable dtSource, string SheetName, string Path, string NewPath, int rowIndex = 0)
        {
            FileStream file = new FileStream(Path, FileMode.Open, FileAccess.Read);
            XSSFWorkbook workbook = new XSSFWorkbook(file);
            XSSFSheet sheet = workbook.GetSheet(SheetName) as XSSFSheet;

            foreach (DataRow row in dtSource.Rows)
            {
                #region 填充内容
                var rowSource = sheet.GetRow(rowIndex);
                var cellSource = rowSource.GetCell(0);//都以第一列的样式复制
                XSSFRow dataRow = sheet.CreateRow(rowIndex) as XSSFRow;
                dataRow.Height = 500;
                foreach (DataColumn column in dtSource.Columns)
                {
                    XSSFCell newCell = dataRow.CreateCell(column.Ordinal) as XSSFCell;
                    newCell.CellStyle = cellSource.CellStyle;

                    String drValue = row[column].ToString();
                    newCell.SetCellValue(drValue);
                }
                #endregion
                rowIndex++;
            }
            FileStream out1 = new FileStream(NewPath, FileMode.Create);
            workbook.Write(out1);
            workbook.Close();
            out1.Close();
        }
    }
}