﻿using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using TicketSpider.Model;

namespace TicketSpider.Spiders.EasterLineRule
{
    public class TicketOrderHelper
    {


        public async Task<(bool result,JObject order)> RunAsync(JObject ticket)
        {
            var flag = true;
            var passengers = PassengerHelper.GLOBAL_USERLIST;
            //此步骤直接使用登录后的cookies
            FormatPassengers(ticket, ref passengers);
            Console.WriteLine("获取航班详情");
            //var details = await GetSingleTicketDetailsAsync(ticket, passengers);
            //Thread.Sleep(1000);
            Console.WriteLine("创建订单模板");
            var verifyFlight = new JObject();
            var verifyCount = 3;
            while (verifyCount>0)
            {
                verifyFlight = await GetSingleTicketVerifyFlightInfoAsync(ticket, passengers);
                if (verifyFlight.ContainsKey("cacheKey"))
                {
                    break;
                }
                else 
                {
                    Console.WriteLine("创建订单模板失败，准备重试");
                    if (verifyCount == 1) 
                    {
                        flag = false;
                        break;
                    }
                }
                verifyCount--;
                Thread.Sleep(2000);
            }

            if (!flag) return (false, new JObject());

            Thread.Sleep(2000);


            Console.WriteLine("获取联系人信息...");
            var concats = new JArray();
            var contactCnt = 3;
            while (contactCnt > 0)
            {
                concats = await GetListContactAsync();
                if (concats.Any())
                {
                    break;
                }
                else
                {
                    Console.WriteLine("获取联系人信息，准备重试");
                    if (contactCnt == 1)
                    {
                        flag = false;
                        break;
                    }
                }
                contactCnt--;
                Thread.Sleep(1000);
            }

            if (!flag) return (false, new JObject());

            Thread.Sleep(1000);


            Console.WriteLine("开始创建订单....");
            var order = new JObject();
            var orderCnt = 3;
            while (orderCnt > 0)
            {
                order = await CreateBookingAsync(ticket, passengers, concats.First() as JObject, verifyFlight["cacheKey"].ToString());
                if (order.ContainsKey("resultCode"))
                {
                    break;
                }
                else
                {
                    Console.WriteLine("创建订单失败，准备重试");
                    if (orderCnt == 1)
                    {
                        flag = false;
                        break;
                    }
                }
                orderCnt--;
                Thread.Sleep(1000);
            }
            if (!flag) return (false, new JObject());

            return (true,order);
        }

        private async Task<JObject> CreateBookingAsync(JObject ticket, List<Passenger> passengers, JObject contact,string tempOrderId)
        {
            var order = new JObject();
            var request = CreateRequest();
            var url = "https://www.ceair.com/portal/v3/booking/";

            #region 组装参数

            var parameters = new JObject();
            var firstFlight = ticket["data"]["flightItems"][0];
            var flightSegment = firstFlight["flightInfos"][0]["flightSegments"][0];
            var cabin = firstFlight["cabinInfoDescs"][0];
            var sort = firstFlight["flightInfos"][0]["flightSort"];
            parameters.Add("calculateInfo", null);
            parameters.Add("channelType", "");
            parameters.Add("depDt", $"{flightSegment["fltDate"].ToString()} {flightSegment["orgTime"].ToString()}");
            parameters.Add("depDtCode", flightSegment["orgCode"].ToString());
            parameters.Add("deviceId", "");
            var favorAddress = @"{
  'docaAddressType': 'R',
  'docaAddress': '',
  'docaCity': '',
  'docaNationCode': '',
  'docaPostcode': '',
  'docaState': ''
}";
            parameters.Add("favorAddress", JObject.Parse(favorAddress.Replace("'", "\"")));
            var favorContact = @$"{{
  'name': '{contact["name"].ToString()}',
  'mobile': '{contact["mobile"].ToString()}',
  'phoneCountry': '86'
}}";
            parameters.Add("favorContact", JObject.Parse(favorContact.Replace("'", "\"")));
            parameters.Add("inter", "T");
            parameters.Add("invoiceInfoList",new JArray());
            parameters.Add("jfType","");
            parameters.Add("orderDiscountDetail",null);
            parameters.Add("points",false);
            parameters.Add("seatInfo",null);
            parameters.Add("sxtCouponInfo",null);
            parameters.Add("tempOrderId", tempOrderId);
            parameters.Add("tripType", "OW");
            parameters.Add("useCoupons",null);
            parameters.Add("userId",AccountManagerHelper._userId);
            parameters.Add("xtypes", new JArray());
            var favorPassengerList = new JArray();
            var docaAddress=new JObject();
            docaAddress.Add("addressD", "");
            docaAddress.Add("cityD", "");
            docaAddress.Add("countryD", "");
            docaAddress.Add("stateD", "");
            docaAddress.Add("zipD", "");
            passengers.ForEach(x => {
                var obj = new JObject();
                obj.Add("beneficiary", false);
                obj.Add("birthday", x.birthday);
                obj.Add("cardType", "");
                obj.Add("carrierName", null);
                obj.Add("cradle", "");
                obj.Add("docaAddress", docaAddress);
                obj.Add("email", x.email);
                obj.Add("gender", x.gender);
                obj.Add("idNo", x.favorPaxIdDtoList[0].idNo);
                obj.Add("idType", "PP");
                obj.Add("member", false);
                obj.Add("mileageCard", "");
                obj.Add("name", $"{x.paxNameFirst}/{x.paxNameLast}");
                obj.Add("natnCd", "CN");
                obj.Add("passengerType", x.paxType);
                obj.Add("paxHolderFG", "Y");
                obj.Add("paxIdDl", DateTime.Now.AddYears(1).ToString("yyyy-MM-dd"));
                obj.Add("paxIdNatnCd", "CN");
                obj.Add("phoneCountry", "86");
                obj.Add("phoneNumber", x.mobile);
                obj.Add("secIdNo", null);
                obj.Add("secIdType", "");
                favorPassengerList.Add(obj);
            });

            parameters.Add("favorPassengerList", favorPassengerList);

            #endregion

            var content = new StringContent(JsonConvert.SerializeObject(parameters), System.Text.Encoding.UTF8, "application/json");
            var response = await request.PostAsync(url, content);
            var result = response.Content.ReadAsStringAsync().Result;
            if (result.Contains("S200"))
            {

                try
                {
                    order = JObject.Parse(result);
                }
                catch (Exception) { }
            }

            return order;
        }

        private string FormatBrithday(string brith) 
        {
            brith = brith.Insert(4, "-");
            brith = brith.Insert(7, "-");
            return brith;
        }

        private void FormatPassengers(JObject ticket, ref List<Passenger> passengers)
        {
            var firstFlight = ticket["data"]["flightItems"][0];
            var sort = firstFlight["flightInfos"][0]["flightSort"];
            var arrd = sort["depDate"].ToString();
            passengers.ForEach(x => {
                x.birthday = FormatBrithday(x.birthday);
                var age = CalculateAgeCorrect(x.birthday, arrd);
                if (age >= 12)
                {
                    x.paxType = "ADT";
                }
                else if (age >= 2)
                {
                    x.paxType = "CHD";
                }
                else 
                {
                    x.paxType = "INF";
                }
            });
        }

        private int CalculateAgeCorrect(string birth,string arrd)
        {
            DateTime birthDate, now;
            birthDate = DateTime.Parse(birth);
            now = DateTime.Parse(arrd);
            int age = now.Year - birthDate.Year;
            if (now.Month < birthDate.Month || (now.Month == birthDate.Month && now.Day < birthDate.Day)) age--;
            return age;
        }

        private async Task<JObject> GetSingleTicketDetailsAsync(JObject ticket, List<Passenger> passengers)
        { 
            var ticketDetails = new JObject();
            var request = CreateRequest();
            var url = "https://www.ceair.com/portal/v3/shopping/fareDetail";
            #region 组装参数
            var firstFlight = ticket["data"]["flightItems"][0];
            var flightSegment = firstFlight["flightInfos"][0]["flightSegments"][0];
            var cabin = firstFlight["cabinInfoDescs"][0];
            var sort = firstFlight["flightInfos"][0]["flightSort"];
            var paramerter=new JObject();
            paramerter.Add("airlineCode", flightSegment["airlineCode"]);
            paramerter.Add("cabinCode", cabin["ccode"].ToString());
            paramerter.Add("cabinLevel", cabin["fareLevel"].ToString());
            paramerter.Add("cacheKey", ticket["cacheKey"].ToString());
            paramerter.Add("currency","CNY");
            paramerter.Add("departDateTime",$"{sort["depDate"].ToString()} {sort["depTime"].ToString()}");
            paramerter.Add("deviceId","");
            paramerter.Add("domesticOrInter", firstFlight["flightInfos"][0]["domesticOrInter"]);
            paramerter.Add("flightFareIdList", (firstFlight["flightInfos"][0]["flightFareIds"] as JArray));
            paramerter.Add("flightInfoIdList",new JArray() { flightSegment["flightInfoId"] });
            paramerter.Add("foldingFlag","1");
            paramerter.Add("ifReschedule","0");
            string intList= @$"
  [{{'itnIndex':'1','segInfos':[{{'segIndex': 1,
  'oriEng': '{flightSegment["orgCode"].ToString()}',
  'desEng': '{flightSegment["destCode"].ToString()}',
  'fltDate': '{flightSegment["fltDate"].ToString()}',
  'depTime': '{flightSegment["orgTime"].ToString()}',
  'arrTime': '{flightSegment["destTime"].ToString()}',
  'carrier': '{flightSegment["carrierCode"].ToString()}',
  'carrier_o': '{flightSegment["airlineCode"].ToString()}',
  'flightNo': '{flightSegment["flightNo"].ToString()}',
  'diType': '{flightSegment["domesticOrInter"].ToString()}',
  'classLevel': '',
  'classCode': '',
  'allCabins': '{flightSegment["allCabins"].ToString()}',
  'planType': '{flightSegment["planeType"].ToString()}'}}]}}]";
            intList = intList.Replace("'", "\"");
            paramerter.Add("itnList",JArray.Parse(intList));
            paramerter.Add("orgCode", flightSegment["orgCode"].ToString());
            int [] pg = new int[3]{ 0, 0, 0 };
            passengers.ForEach(x => {
                if (x.paxType == "CHD")
                {
                    pg[1] = pg[1] + 1;
                }
                else if (x.paxType == "INF")
                {
                    pg[2] = pg[2] + 1;
                }
                else
                {
                    pg[0] = pg[0] + 1;
                }
            });
            paramerter.Add("passengerCount",string.Join(',',pg));
            paramerter.Add("priceSource",cabin["fareInfoDescList"][0]["priceSource"].ToString());
            paramerter.Add("productCode", cabin["fareInfoDescList"][0]["productCode"].ToString());
            paramerter.Add("routeType","OW");
            paramerter.Add("segNum",passengers.Count);
            paramerter.Add("sequenceId", flightSegment["sequenceId"].ToString());
            #endregion

            var content = new StringContent(JsonConvert.SerializeObject(paramerter), System.Text.Encoding.UTF8, "application/json");
            var response = await request.PostAsync(url, content);
            var result = response.Content.ReadAsStringAsync().Result;
            if (result.Contains("S200"))
            {

                try
                {
                    ticketDetails = JObject.Parse(result)["data"] as JObject;
                }
                catch (Exception) { }
            }
            
            return ticketDetails;
        }

        private async Task<JObject> GetSingleTicketVerifyFlightInfoAsync(JObject ticket, List<Passenger> passengers)
        { 
            var result=new JObject();

            var request = CreateRequest();
            var url = "https://www.ceair.com/portal/v3/shopping/verifyFlightInfo";
            #region 组装参数
            var firstFlight = ticket["data"]["flightItems"][0];
            var flightSegment = firstFlight["flightInfos"][0]["flightSegments"][0];
            var cabin = firstFlight["cabinInfoDescs"][0];
            var sort = firstFlight["flightInfos"][0]["flightSort"];
            var paramerter = new JObject();
            paramerter.Add("cacheKey", ticket["cacheKey"].ToString());
            paramerter.Add("checkFareSource", cabin["fareInfoDescList"][0]["priceSource"].ToString());
            paramerter.Add("deviceId", "");
            paramerter.Add("fId", ticket["fId"].ToString());
            var flightItems = @$"[
  {{
    'depCode': '{flightSegment["orgCode"].ToString()}',
    'arrCode': '{flightSegment["destCode"].ToString()}',
    'depDt': '{sort["depDate"].ToString()}',
    'odType': 0,
    'index': 1,
    'flightInfoList': [
      {{
        'depCode': '{flightSegment["orgCode"].ToString()}',
        'arrCode': '{flightSegment["destCode"].ToString()}',
        'depDt': '{sort["depDate"].ToString()}',
        'carrierO': '{flightSegment["carrierCode"].ToString()}',
        'flightNoO': '{flightSegment["carrierNo"].ToString()}',
        'carrier': '{flightSegment["airlineCode"].ToString()}',
        'flightNo': '{flightSegment["flightNo"].ToString()}',
        'depTime': '{flightSegment["orgTime"].ToString()}',
        'arriveTime': '{flightSegment["destTime"].ToString()}',
        'arriveDate': '{flightSegment["arriDate"].ToString()}',
        'sequenceId': '{flightSegment["sequenceId"].ToString()}',
        'tripId': null,
        'cabin': '{cabin["ccode"].ToString()}',
        'pricePointId': null
      }}
    ]
  }}
]";
            flightItems = flightItems.Replace("'", "\"");
            paramerter.Add("flightItems", JArray.Parse(flightItems));
            paramerter.Add("flightType", flightSegment["domesticOrInter"].ToString());
            paramerter.Add("ifReschedule", "0");
            paramerter.Add("originalRoute", null);
            paramerter.Add("routeType", "OW");
            paramerter.Add("searchOneFlag", false);
            paramerter.Add("shoppingKey", null);
            int[] pg = new int[3] { 0, 0, 0 };
            passengers.ForEach(x => {
                if (x.paxType == "CHD")
                {
                    pg[1] = pg[1] + 1;
                }
                else if (x.paxType == "INF")
                {
                    pg[2] = pg[2] + 1;
                }
                else
                {
                    pg[0] = pg[0] + 1;
                }
            });
            var preference = @$"{{
  'adtCount': {pg[0]},
  'chdCount': {pg[1]},
  'infCount': {pg[2]},
  'currencyCode': 'CNY',
  'productCode': '{cabin["fareInfoDescList"][0]["productCode"].ToString()}',
  'brandLevel': '{cabin["fareInfoDescList"][0]["brandLevel"].ToString()}',
  'onlyPlaneFlag': false
}}";
            preference = preference.Replace("'", "\"");
            paramerter.Add("preference", JObject.Parse(preference));
            #endregion

            var content = new StringContent(JsonConvert.SerializeObject(paramerter), System.Text.Encoding.UTF8, "application/json");
            var response = await request.PostAsync(url, content);
            var resultStr = response.Content.ReadAsStringAsync().Result;
            if (resultStr.Contains("S200"))
            {

                try
                {
                    result = JObject.Parse(resultStr)["data"] as JObject;
                }
                catch (Exception) { }
            }
            return result;
        }

        private async Task<JArray> GetListContactAsync()
        {
            var result = new JArray();

            var request = CreateRequest();
            var url = "https://www.ceair.com/portal/v3/customer/listContact";
            var content = new StringContent("{\"deviceId\":\"\"}", System.Text.Encoding.UTF8, "application/json");
            var response = await request.PostAsync(url, content);
            var resultStr = response.Content.ReadAsStringAsync().Result;
            if (resultStr.Contains("U200"))
            {

                try
                {
                    result = JObject.Parse(resultStr)["resultContent"] as JArray;
                }
                catch (Exception) { }
            }
            return result;
        }

        private HttpClient CreateRequest()
        {
            var handler = new HttpClientHandler();
            handler.AllowAutoRedirect = false;
            handler.UseCookies = true;
            handler.CookieContainer = CreateCookie(AccountManagerHelper.GetInstance());
            handler.AutomaticDecompression = DecompressionMethods.GZip;
            handler.ClientCertificateOptions = ClientCertificateOption.Automatic;
            var http = new HttpClient(handler);
            CreateRequestHeaders(ref http);

            return http;
        }

        private CookieContainer CreateCookie(string cookieStr)
        {
            var uri = new Uri("https://www.ceair.com");
            var cc = new CookieContainer();
            foreach (var str in cookieStr.Split(';'))
            {
                cc.SetCookies(uri, str);
            }
            return cc;
        }

        private void CreateRequestHeaders(ref HttpClient http)
        {
            var random = new Random();
            http.DefaultRequestHeaders.Add("Accept", "application/json, text/plain, */*");
            http.DefaultRequestHeaders.Add("Accept-Encoding", "gzip, deflate, br");
            http.DefaultRequestHeaders.Add("Accept-Language", "zh-CN,zh;q=0.9");
            http.DefaultRequestHeaders.Add("Cache-Control", "no-cache");
            //http.DefaultRequestHeaders.Add("Connection", "keep-alive");
            //http.DefaultRequestHeaders.Add("Content-Length", "188");
            //http.DefaultRequestHeaders.Add("Content-Type", new MediaTypeHeaderValue("application/json"));
            //http.DefaultRequestHeaders.Add("Host", "m.ceair.com");
            http.DefaultRequestHeaders.Add("Origin", "https://www.ceair.com");
            http.DefaultRequestHeaders.Add("Pragma", "no-cache");
            http.DefaultRequestHeaders.Add("Referer", "https://www.ceair.com/leftNavigation/personCenter/passengers");
            //http.DefaultRequestHeaders.Add("salesChannel", "NzcwMQ==");
            http.DefaultRequestHeaders.Add("sec-ch-ua", "\" Not; A Brand\";v=\"99\", \"Google Chrome\";v=\"97\", \"Chromium\";v=\"97\"");
            http.DefaultRequestHeaders.Add("sec-ch-ua-mobile", "?0");
            http.DefaultRequestHeaders.Add("sec-ch-ua-platform", "\"Windows\"");
            http.DefaultRequestHeaders.Add("Sec-Fetch-Dest", "empty");
            http.DefaultRequestHeaders.Add("Sec-Fetch-Mode", "cors");

            http.DefaultRequestHeaders.Add("Sec-Fetch-Site", "same-origin");
            http.DefaultRequestHeaders.Add("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.99 Safari/537.36");
            http.DefaultRequestHeaders.Add("x-tingyun-id", $"DuR5xFLm8eI;r={random.Next(100000000, 999999999)}");

            http.DefaultRequestHeaders.Add("site", "zh_CN");
            http.DefaultRequestHeaders.Add("shakehand", "535206fb27efbaf75066ff179b975ff6");
            http.DefaultRequestHeaders.Add("pragma", "no-cache");
        }
    }
}
