﻿using EduSpider.Model.Entity;
using EduSpider.Model.Query;
using System.Collections.Generic;
using VTX.FW.Config;
using VTX.FW.DB;

namespace EduSpider.Repository
{
    /// <summary>
    /// 课程学员关联仓储接口
    /// </summary>
    public interface ICourseStudentRepository : IDBRepository<RB_Course_Student>, IDependency
    {
        /// <summary>
        /// 批量新增课程学员
        /// </summary>
        /// <param name="courses"></param>
        /// <returns></returns>
        public bool BatchSetCourseStudentRepository(List<RB_Course_Student> courses);


        /// <summary>
        /// 跟进查询条件获取课程学员列表
        /// </summary>
        /// <param name="courseQuery"></param>
        /// <returns></returns>
        public List<RB_Course_Student> GetCourseStudentListRepository(CourseQuery query);

    }
}
