﻿using System;
using VTX.FW.Attr;

namespace EduSpider.Model.Entity
{
    /// <summary>
    /// 作业实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_HomeWork
    {
		/// <summary>
		/// 作业编号
		/// </summary>
		public int homework_id { get; set; }

		/// <summary>
		/// 作业标题
		/// </summary>
		public string homework_title { get; set; }

		/// <summary>
		/// 作业分享Key
		/// </summary>
		public string homework_share_key { get; set; }

		/// <summary>
		/// 课程编号
		/// </summary>
		public int course_id { get; set; }

		/// <summary>
		/// 课程名称
		/// </summary>
		public string course_name { get; set; }

		/// <summary>
		/// 作业开始时间
		/// </summary>
		public DateTime start_time { get; set; }

		/// <summary>
		/// 作业结束时间
		/// </summary>
		public DateTime end_time { get; set; }

		/// <summary>
		/// 作业状态(0-未开始，1-进行中，2-已结束)
		/// </summary>
		public int status { get; set; }

		/// <summary>
		/// 显示状态(0-客户端显示，1-客户端隐藏)
		/// </summary>
		public int is_del { get; set; }

		/// <summary>
		/// 是否公开作业(1-公开作业，2-不公开，3-公开优秀)
		/// </summary>
		public int is_open { get; set; }

		/// <summary>
		/// 公开方式(1-结束后)
		/// </summary>
		public int open_type { get; set; }

		/// <summary>
		/// 是否允许补交(1-否,2-是)
		/// </summary>
		public int is_revise { get; set; }

		/// <summary>
		/// 学生数
		/// </summary>
		public int num { get; set; }

		/// <summary>
		/// 优秀人数
		/// </summary>
		public int cream_num { get; set; }

		/// <summary>
		/// 补交人数
		/// </summary>
		public int revised_num { get; set; }

		/// <summary>
		/// 已批阅
		/// </summary>
		public int rnum { get; set; }

		/// <summary>
		/// 已提交
		/// </summary>
		public int cnum { get; set; }

		/// <summary>
		/// 学校编号
		/// </summary>
		public int school_uid { get; set; }

		/// <summary>
		/// 评分机制(5-自定义，4-不评分，3-等第制，2-十分制，1-百分制)
		/// </summary>
		public int score_type { get; set; }

		/// <summary>
		/// 自定义分数
		/// </summary>
		public decimal score_value { get; set; }

		/// <summary>
		/// 教师账号
		/// </summary>
		public string teacher_account { get; set; }

		/// <summary>
		/// 教师姓名
		/// </summary>
		public string teacher_name { get; set; }

		/// <summary>
		/// 教师编号
		/// </summary>
		public int teacher_uid { get; set; }

		/// <summary>
		/// th_cancel
		/// </summary>
		public string th_cancel { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime add_time { get; set; }

		/// <summary>
		/// 更新时间
		/// </summary>
		public DateTime update_time { get; set; }

		public int ref_num { get; set; }


		public int refc_num { get; set; }

		public decimal av_score { get; set; }

		public decimal max_score { get; set; }

		public decimal min_score { get; set; }
	}
}
