﻿using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Repository.Base;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EduSpider.Repository
{
    /// <summary>
    /// 账号仓储层
    /// </summary>
    public class AccountRepository : BaseRepository<RB_Account>, IAccountRepository
    {
        /// <summary>
        /// 批量新增账号
        /// </summary>
        /// <param name="accounts"></param>
        /// <returns></returns>
        public bool BatchSetAccount(List<RB_Account> accounts)
        {
            return base.BatchInsert(accounts, isReplace: true);
        }

        /// <summary>
        /// 获取账户列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Account_Extend> GetAccountList(RB_Account_Extend demodel)
        {
            string where = " 1=1 ";
            if (demodel.Id > 0)
            {
                where += $" and t.{nameof(RB_Account_Extend.Id)} ={demodel.Id}";
            }
            if (demodel.AccountType > 0)
            {
                where += $" and t.{nameof(RB_Account_Extend.AccountType)} ={demodel.AccountType}";
            }
            if (demodel.AccountId > 0)
            {
                where += $" and t.{nameof(RB_Account_Extend.AccountId)} ={demodel.AccountId}";
            }
            if (demodel.Status > -1)
            {
                where += $" and t.{nameof(RB_Account_Extend.Status)} ={demodel.Status}";
            }
            if (!string.IsNullOrEmpty(demodel.Account))
            {
                where += $" and t.{nameof(RB_Account_Extend.Account)} ='{demodel.Account}'";
            }
            if (!string.IsNullOrEmpty(demodel.Password))
            {
                where += $" and t.{nameof(RB_Account_Extend.Password)} ='{demodel.Password}'";
            }

            string sql = $@"
select * from(
SELECT a.Id,a.Account,a.`Password`,a.AccountType,a.AccountId,t.TeacherName AS AccountName,a.Status FROM rb_account a 
INNER JOIN rb_teacher t on a.AccountId =t.TeacherId and a.AccountType =1
UNION 
SELECT a.Id,a.Account,a.`Password`,a.AccountType,a.AccountId,s.StudentName AS AccountName,a.Status FROM rb_account a 
INNER JOIN rb_student s on a.AccountId =s.StudId and a.AccountType =2
) t where {where}
";
            return Get<RB_Account_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取最大ID
        /// </summary>
        /// <param name="type"></param>
        /// <returns></returns>
        public int GetMaxStuTeaId(int type)
        {
            string sql = $" select max(AccountId) from RB_Account where AccountType ={type}";
            var obj = ExecuteScalar(sql);
            return obj == null ? 0 : Convert.ToInt32(obj);
        }
    }
}
