﻿using EduSpider.IServices;
using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.WebApi.Controllers.Base;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json.Linq;
using System.Collections.Generic;
using VTX.FW.Api;
using VTX.FW.Attr;
using VTX.FW.Helper;
using System.Linq;
using EduSpider.Model.Query;

namespace EduSpider.WebApi.Controllers
{
    /// <summary>
    /// 老师相关控制器
    /// </summary>
    public class TeacherController : BaseController
    {

        /// <summary>
        /// 课程仓储接口
        /// </summary>
        [Autowired]
        public ICourseService CourseService { get; set; }

        /// <summary>
        /// 获取老师课程列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult GetTeacherCourse()
        {
            var userInfo = base.UserInfo;
            var query = new CourseQuery()
            {
                TeacherIds = userInfo.AccountId.ToString(),
                KeyWords = base.ReqParameters.GetString("KeyWords"),
            };

            //全部课程
            List<object> AllCourseList = new();
            //已结课
            List<object> FinishList = new();
            //进行中
            List<object> NotFinishList = new();
            var list = CourseService.GetTeacherCourseList(query).Where(qitem => qitem.CourseStatus == 1 || qitem.CompleteNum == qitem.TotalClassNum).ToList();

            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    var obj = new
                    {
                        item.courseId,
                        item.CourseName,
                        item.CoverImg,
                        item.CompleteNum,
                        item.TotalClassNum,
                        item.TeacherName,
                    };
                    AllCourseList.Add(obj);
                    if (item.CompleteNum == item.TotalClassNum)
                    {
                        FinishList.Add(obj);
                    }
                    else
                    {
                        NotFinishList.Add(obj);
                    }
                }
            }
            var result = new { AllCourseList, FinishList, NotFinishList };
            return ApiResult.Success(data: result);
        }

        /// <summary>
        /// 获取课程学员列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult GetCourseStu()
        {
            var query = new CourseQuery()
            {
                CourseId = base.ReqParameters.GetInt("courseId")
            };
            List<object> result = new();
            if (query.CourseId <= 0)
            {
                return ApiResult.ParamIsNull();
            }
            var list = CourseService.GetStuCourseList(query);
            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    result.Add(new
                    {
                        StuId = item.uid,
                        StuName = item.name,
                        StuAccount = item.account
                    });
                }
            }
            return ApiResult.Success(data: result);
        }

        /// <summary>
        /// 获取课程作业列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult GetCourseHomeWork()
        {
            var query = new Model.Query.CourseQuery()
            {
                CourseId = base.ReqParameters.GetInt("courseId")
            };

            if (query.CourseId <= 0)
            {
                return ApiResult.ParamIsNull();
            }

            var list = CourseService.GetCourseHomeWork(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 获取课程家庭作业详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult GetHomeWorkDetails()
        {
            var query = new Model.Query.CourseQuery()
            {
                HomeWorkId = base.ReqParameters.GetInt("HomeWorkId")
            };
            if (query.HomeWorkId <= 0)
            {
                return ApiResult.ParamIsNull();
            }
            var list = CourseService.GetHomeWorkDetails(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 获取课程配置评价信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult GetCourseComment()
        {
            var query = new Model.Query.CourseQuery()
            {
                CourseId = base.ReqParameters.GetInt("CourseId"),
                CourseName=base.ReqParameters.GetString("CourseName"),
                CommentTimes=base.ReqParameters.GetInt("Times"),
            };
            var courseRule = CourseService.GetCourseCommentList(query).FirstOrDefault();
            object result=new();
            if (courseRule != null)
            {
                result = new
                {
                    courseRule.Id,
                    courseRule.Title,
                    courseRule.CourseId,
                    courseRule.Times,
                    CommentDetails =courseRule.CommentDetails.OrderBy(qitem=>qitem.StartNum).ToList()
                };
            }
            else
            {
                var sysModel = CourseService.GetSysComment(new CourseQuery()
                {
                    KeyWords = query.CourseName,
                    CommentTimes = query.CommentTimes,
                    IsMatchKeyWords = 1
                }).FirstOrDefault();
                if (sysModel != null)
                {
                    result = new
                    {
                        Id = 0,
                        Title = "系统默认配置",
                        query.CourseId,
                        Times = query.CommentTimes,
                        CommentDetails = sysModel.Details,
                    };
                }
                else
                {
                    result = new
                    {
                        Id = 0,
                        Title = "系统默认配置",
                        query.CourseId,
                        Times = query.CommentTimes,
                        CommentDetails = new List<RB_Comment_Details>()
                    };
                }
            }
            return ApiResult.Success(data: result);
        }

        /// <summary>
        /// 获取课程配置评价列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult GetCourseCommentList()
        {
            var query = new Model.Query.CourseQuery()
            {
                CourseId = base.ReqParameters.GetInt("CourseId"),
                CourseName = base.ReqParameters.GetString("CourseName"),
            };
            var courseRuleList = CourseService.GetCourseCommentList(query).OrderBy(qitem=>qitem.Times).ToList();
            var sysCommentList = CourseService.GetSysComment(new CourseQuery() { KeyWords = query.CourseName, CommentTimes = query.CommentTimes ,IsMatchKeyWords=1}).OrderBy(qitem => qitem.Times).ToList();
           
            List<object> result = new();
            for (var i = 1; i <= 3; i++)
            {
                var tempCourseRule = courseRuleList.Where(qitem => qitem.Times == i).FirstOrDefault();
                var defaultRule = sysCommentList.Where(qitem => qitem.Times == i).FirstOrDefault();
                int IsDefault = 0;
                int Id = 0;
                List<object> SubList = new List<object>();
                if (tempCourseRule != null)
                {
                    Id = tempCourseRule.Id;
                    if (tempCourseRule.CommentDetails != null && tempCourseRule.CommentDetails.Count > 0)
                    {
                        foreach (var subItem in tempCourseRule.CommentDetails)
                        {
                            SubList.Add(new
                            {
                                subItem.DetailId,
                                subItem.CourseCommentId,
                                subItem.StartNum,
                                subItem.EndNum,
                                subItem.Info,
                            });
                        }
                    }
                }
                else if (defaultRule != null)
                {
                    Id = defaultRule.Id;
                    IsDefault = 1;
                    if (defaultRule.Details != null && defaultRule.Details.Count > 0)
                    {
                        foreach (var subItem in defaultRule.Details)
                        {
                            SubList.Add(new
                            {
                                DetailId = 0,
                                CourseCommentId = 0,
                                subItem.StartNum,
                                subItem.EndNum,
                                subItem.Info,
                            });
                        }
                    }
                }

                if (Id > 0)
                {
                    result.Add(new
                    {
                        IsDefault,
                        Id,
                        Times = i,
                        CommentDetails = SubList
                    });
                }
            }
 
            return ApiResult.Success(data: result);
        }


        /// <summary>
        /// 新增可以课程评语
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult SetCourseComment()
        {
            var model = new RB_Course_Comment_Extend()
            {
                Id = base.ReqParameters.GetInt("Id"),
                CourseId = base.ReqParameters.GetInt("CourseId"),
                Title = base.ReqParameters.GetString("Title"),
                ShowType = base.ReqParameters.GetInt("ShowType"),
                Times=base.ReqParameters.GetInt("Times"),
            };
            model.CreateBy = base.BaseUserId;
            model.CreateTime = System.DateTime.Now;
            model.Status = 0;
            model.CommentDetails = new List<RB_Course_CommentDetails_Extend>();
            string commentDetails = base.ReqParameters.GetString("CommentDetails");
            if (!string.IsNullOrWhiteSpace(commentDetails))
            {
                JArray array = JArray.Parse(commentDetails);
                if (array != null && array.Count > 0)
                {
                    foreach (var jItem in array)
                    {
                        var sObj = JObject.Parse(jItem.ToString());
                        var details = new RB_Course_CommentDetails_Extend()
                        {
                            DetailId = sObj.GetInt("DetailId"),
                            CourseCommentId = sObj.GetInt("CourseCommentId"),
                            StartNum = sObj.GetDecimal("StartNum"),
                            EndNum = sObj.GetDecimal("EndNum"),
                            Info = sObj.GetString("Info"),
                            Status = 0,
                            CreateBy = base.BaseUserId,
                            CreateTime = System.DateTime.Now,
                            UpdateBy = base.BaseUserId,
                            UpdateTime = System.DateTime.Now,
                        };
                        model.CommentDetails.Add(details);
                    }
                }
            }
            var flag = CourseService.SetCourseComment(model);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 删除课程评语
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult RemoveCourseComment()
        {
            string Ids = base.ReqParameters.GetString("Ids");
            var flag = CourseService.DeleteCourseComment(Ids);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 根据编号删除课程评价详情配置
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult RemoveCourseCommentDetail()
        {
            string DetailIds = base.ReqParameters.GetString("DetailIds");
            var flag = CourseService.DeleteCourseCommentDetail(DetailIds);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 批量新增学员评价
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult BatchSetStuComment()
        {
            var stuListStr = base.ReqParameters.GetString("ChooseStuList");
            var model = new RB_Stu_Comment_Extend()
            {
                Id = base.ReqParameters.GetInt("Id"),
                Times = base.ReqParameters.GetInt("Times"),
                CourseId = base.ReqParameters.GetInt("CourseId"),
                Title = base.ReqParameters.GetString("Title"),
                CreateType = 2,
                CreateTime = System.DateTime.Now,
                CreateBy = base.BaseUserId,
                CreateByName = base.UserInfo.AccountName,
                ShowType = 3,
                Details = new List<RB_Stu_CommentDetails>()
            };
            StuCommentType commentType = new()
            {
                CommentId = base.ReqParameters.GetInt("CommentId"),
                CommentType = base.ReqParameters.GetInt("CommentType"),
                IsDefault = base.ReqParameters.GetInt("IsDefault")
            };
            List<RB_Stu_CommentDetails> list = new();
            if (!string.IsNullOrWhiteSpace(stuListStr))
            {
                JArray jArray = JArray.Parse(stuListStr);
                if (jArray != null && jArray.Count > 0)
                {
                    var homeworkIds=  base.ReqParameters.GetString("HomeWorkIds");
                    List<int> homeIds = new();
                    if (!string.IsNullOrWhiteSpace(homeworkIds))
                    {
                        homeIds = VTX.FW.Helper.JsonHelper.Deserialize<List<int>>(homeworkIds);
                    }
                    foreach (var jItem in jArray)
                    {
                        JObject stuObj = JObject.Parse(jItem.ToString());

                        var subModel = new RB_Stu_CommentDetails()
                        {
                            Id = base.ReqParameters.GetInt("Id"),
                            StartHomeWorkId = base.ReqParameters.GetInt("StartHomeWorkId"),
                            HomeWorkId = base.ReqParameters.GetInt("HomeWorkId"),
                            StuUid = stuObj.GetInt("StuId"),
                            CourseId = base.ReqParameters.GetInt("CourseId"),
                            Times = base.ReqParameters.GetInt("Times"),
                            Info = base.ReqParameters.GetString("Info"),
                            CreateType = 2,
                            HomeWorkIds = string.Join(",", homeIds)
                        };
                        subModel.ShowType = 3;
                        subModel.Status = 0;
                        subModel.CreateTime = System.DateTime.Now;
                        subModel.CreateBy = base.BaseUserId;
                        subModel.CreateByName = base.UserInfo.AccountName;
                        list.Add(subModel);
                    }
                }
            }
            model.Details = list;
            var flag = CourseService.BatchSetStuComment(model, commentType);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }


        /// <summary>
        /// 修改学员评价
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult SetStuCommentInfo()
        {
            string Id = base.ReqParameters.GetString("Id");
            string Info = base.ReqParameters.GetString("Info");
            var flag = CourseService.SetStuCommentDetailsInfo(Id, Info);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }


        /// <summary>
        /// 修改学员评论状态
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult SetStuCommentShowType()
        {
            string Ids = base.ReqParameters.GetString("Ids");
            int ShowType = base.ReqParameters.GetInt("ShowType");
            var flag = CourseService.SetStuCommentDetailsShowType(ShowType, Ids);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 设置学员评论可见性
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult SetStuCommentShowTypeByTimes()
        {
            int CourseId = base.ReqParameters.GetInt("CourseId");
            int CommentMainId = base.ReqParameters.GetInt("CommentMainId");
            int ShowType = base.ReqParameters.GetInt("ShowType");
            var flag = CourseService.SetStuCommentShowTypeByTimes(CourseId, CommentMainId, ShowType); ;
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取课程已经生成的评论统计列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult GetCourseCommentTimes()
        {
            var query = new CourseQuery()
            {
                CourseId = base.ReqParameters.GetInt("CourseId"),
               // CreateCommentType = 1
            };
            List<object> result = new();
            var list = CourseService.GetCourseCommentTimesList(query);
            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    string ShowTypeStr = "";
                    if (item.ShowType == 1)
                    {
                        ShowTypeStr = "全部可见";
                    }
                    else if (item.ShowType == 2)
                    {
                        ShowTypeStr = "部分可见";
                    }
                    else if (item.ShowType == 3)
                    {
                        ShowTypeStr = "不可见";
                    }
                    result.Add(new
                    {
                        item.Id,
                        item.Times,
                        item.Title,
                        item.CourseId,
                        item.CreateType,
                        CreateTypeStr = item.CreateType == 1 ? "系统创建" : "老师创建",
                        item.ShowType,
                        ShowTypeStr,
                        CreateTime = VTX.FW.Helper.ConvertHelper.FormatDate(item.CreateTime),
                        optionsShow = false,
                    });
                }
            }
            return ApiResult.Success(data: result);
        }


        /// <summary>
        /// 获取学员评论列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult GetStuCommentList()
        {
            var query = new RB_Stu_CommentDetails_Extend()
            {
                CourseId = base.ReqParameters.GetInt("CourseId"),
                Times = base.ReqParameters.GetInt("CommentTimes"),
                CommentMainId=base.ReqParameters.GetInt("CommentMainId"),
            };
            List<object> result = new();
            var list = CourseService.GetStuCommentDetailsList(query);
            if (list.Any())
            {
                foreach (var item in list)
                {
                    string ShowTypeStr = "";
                    if (item.ShowType == 1)
                    {
                        ShowTypeStr = "可见";
                    }
                    else if (item.ShowType == 2)
                    {
                        ShowTypeStr = "部分可见";
                    }
                    else if (item.ShowType == 3)
                    {
                        ShowTypeStr = "不可见";
                    }
                    result.Add(new
                    {
                        item.Id,
                        item.HomeWorkId,
                        item.StuUid,
                        item.StuName,
                        item.CourseId,
                        item.Times,
                        item.Info,
                        item.CreateType,
                        CreateTypeStr = item.CreateType == 1 ? "系统创建" : "老师创建",
                        item.ShowType,
                        ShowTypeStr,
                        CreateTime = VTX.FW.Helper.ConvertHelper.FormatDate(item.CreateTime)
                    });
                }
            }
            return ApiResult.Success(data: result);
        }


        /// <summary>
        /// 删除学生评论
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult RemoveStuComment()
        {
            string Ids = base.ReqParameters.GetString("Ids");
            if (string.IsNullOrEmpty(Ids))
            {
                return ApiResult.ParamIsNull(message: "请选择要删除的评论!");
            }
            var list = CourseService.RemoveStuComment(Ids);
            return ApiResult.Success(data: list);
        }


        /// <summary>
        /// 生成课程评论
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult CreateCourseComment()
        {
            int CourseId = base.ReqParameters.GetInt("CourseId");
            var list=  CourseService.CreateHomeWorkComment(CourseId);
            return ApiResult.Success(data: list);
        }
    }
}
