﻿using EduSpider.IRepository;
using EduSpider.Model.Entity;
using EduSpider.Repository.Base;
using System.Collections.Generic;
using System.Linq;

namespace EduSpider.Repository
{
    public class StudentRepository : BaseRepository<rb_student_hk>, IStudentRepository
    {
        public bool BatchSetStudent(List<rb_student_hk> students)
        {
            bool flag;
            flag = base.BatchInsert(students, isReplace: true);
            return flag;
        }

        /// <summary>
        /// 获取学生列表 根据学生姓名
        /// </summary>
        /// <param name="stuNames"></param>
        /// <param name="courseId"></param>
        /// <returns></returns>
        public List<rb_student_hk> GetListForStuName(string stuNames, int courseId)
        {
            string sql = $@"select s.StudId,s.StudentUid,s.StudentName from rb_student_hk s
inner join rb_course_student c on s.StudId = c.id
where s.StudentName in({stuNames}) and c.courseId ={courseId} order by s.StudId desc";
            return Get<rb_student_hk>(sql).ToList();
        }
    }
}
