﻿using EduSpider.IRepository;
using EduSpider.Model.Entity;
using EduSpider.Model.Query;
using EduSpider.Repository.Base;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VTX.FW.DB;

namespace EduSpider.Repository
{
    /// <summary>
    /// 学员评语仓储接口实现
    /// </summary>
    public class StuCommentRepository : BaseRepository<RB_Stu_Comment>, IStuCommentRepository
    {
        /// <summary>
        /// 获取学员评语列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Stu_Comment> GetStuCommentListRepository(CourseQuery query)
        {
            StringBuilder builder = new();
            builder.AppendFormat(@"
SELECT A.*
FROM RB_Stu_Comment AS A
WHERE 1=1
");
            if (query != null)
            {
                if (query.CourseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Stu_Comment.CourseId), query.CourseId);
                }
                if (!string.IsNullOrWhiteSpace(query.StuIds))
                {
                    builder.AppendFormat(" AND A.{0} IN({1}) ", nameof(RB_Stu_Comment.StuUid), query.StuIds);
                }
                if (query.HomeWorkId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Stu_Comment.HomeWorkId), query.HomeWorkId);
                }
            }
            return Get<RB_Stu_Comment>(builder.ToString()).ToList();
        }

        /// <summary>
        /// 新增修改学员评语
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetStuCommentRepository(RB_Stu_Comment model)
        {
            bool flag;
            if (model.Id > 0)
            {
                Dictionary<string, object> fileds = new()
                {
                    {nameof(RB_Stu_Comment.Info),model.Info },
                };
                flag = base.UpdateOne(fileds, new WhereHelper(nameof(RB_Stu_Comment.Id), model.Id));
            }
            else
            {
                var newId = base.Insert(model);
                model.Id = newId;
                flag = newId > 0;
            }
            return flag;
        }
    }
}
