﻿using EduSpider.IServices;
using EduSpider.WebApi.Controllers.Base;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json.Linq;
using VTX.FW.Api;
using VTX.FW.Attr;
using VTX.FW.Helper;
using EduSpider.Utility;
using System.Threading;
using EduSpider.Model.Extend;
using System.Linq;
using JWT;
using System;
using System.Collections.Generic;
using JWT.Algorithms;
using JWT.Serializers;
using EduSpider.Utility.API;

namespace EduSpider.WebApi.Controllers
{
    /// <summary>
    /// 登录
    /// </summary>

    public class LoginController : BaseController
    {
        /// <summary>
        /// 账号仓储接口
        /// </summary>
        [Autowired]
        public IAccountService accountService { get; set; }

        /// <summary>
        /// 账号密码登录
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        [AllowAnonymous]
        public ApiResult Login()
        {
            JObject jobj = JObject.Parse(RequestParm.Msg.ToString());
            string account = jobj.GetString("Account");
            string password = jobj.GetString("Password");
            string UnionId = jobj.GetString("UnionId");
            string OpenId = jobj.GetString("OpenId");

            var model = accountService.GetAccountList(new RB_Account_Extend()
            {
                Account = account.Trim()
            }).FirstOrDefault();
            if (model == null)
            {
                return ApiResult.Failed(message: "用户不存在", new { Error = -1 });
            }
            else
            {
                if (password != "Viitto!@#123")
                {
                    password = DES.Encrypt(password);
                    if (model.Password != password)
                    {
                        return ApiResult.Failed("密码错误", new { Error = 0 });
                    }
                }
                if (!string.IsNullOrEmpty(model.OpenId))//UnionId是否为空，为空则绑定手机号与UnionId
                {
                    model.UnionId = UnionId;
                    model.OpenId = OpenId;
                    accountService.UpdateAccountUnionId(model);
                }
                if (model.Status == Utility.Enum.DateStateEnum.Delete)
                {
                    return ApiResult.Failed(message: $"此账号【{ account }】已禁用", new { Error = 2 });
                }

                #region 获取进阶思维小程序端token
                TokenUserInfo UserInfo = new() { uid = model.Id.ToString(), requestFrom = Utility.Enum.ApiRequestFromEnum.MiniProgram };
                #region JWT
                IDateTimeProvider provider = new UtcDateTimeProvider();
                var now = provider.GetNow().AddMinutes(-1);
                var unixEpoch = new DateTime(1970, 1, 1, 0, 0, 0, DateTimeKind.Utc); // or use JwtValidator.UnixEpoch
                var secondsSinceEpoch = Math.Round((now - unixEpoch).TotalSeconds);
                var payload = new Dictionary<string, object>
                {
                        {"iat",secondsSinceEpoch },
                        {"exp",secondsSinceEpoch + Config.JwtExpirTime },
                        {"jjsw_userInfo", UserInfo }
                };
                IJwtAlgorithm algorithm = new HMACSHA256Algorithm();
                IJsonSerializer serializer = new JsonNetSerializer();
                IBase64UrlEncoder urlEncoder = new JwtBase64UrlEncoder();
                IJwtEncoder encoder = new JwtEncoder(algorithm, serializer, urlEncoder);
                string secret = Config.JwtSecretKey;
                string token = encoder.Encode(payload, secret);
                #endregion                
                #endregion

                Model.Cache.UserInfo obj = new Model.Cache.UserInfo
                {
                    Id = model.Id,
                    AccountType = model.AccountType,
                    AccountName = model.AccountName,
                    Token = token,
                    ApiRequestFromEnum = Utility.Enum.ApiRequestFromEnum.MiniProgram,
                    AccountId = model.AccountId,
                    UserMobile = model.Account,
                    UserIcon = model.UserIcon,
                };
                Cache.User.UserReidsCache.UserInfoSet(Cache.CacheKey.User_Login_Key + model.Id, obj, Config.JwtExpirTime);
                return ApiResult.Success(data: obj);
            }
        }

        /// <summary>
        /// 根据手机号码一键登录
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        [AllowAnonymous]
        public ApiResult LoginByAccount()
        {
            JObject jobj = JObject.Parse(RequestParm.Msg.ToString());
            string account = jobj.GetString("Account");
            string UnionId = jobj.GetString("UnionId");
            string OpenId = jobj.GetString("OpenId");
            //string WeChatName = jobj.GetString("WeChatName");
            //string WeChatPhoto = jobj.GetString("WeChatPhoto");
            if (string.IsNullOrEmpty(account))
            {
                return ApiResult.Failed(message: "手机号码登录失败、跳转至账号登录", new { Error = -1 });
            }
            var model = accountService.GetAccountList(new RB_Account_Extend()
            {
                Account = account.Trim()
            })?.FirstOrDefault();
            if (model == null)
            {
                return ApiResult.Failed(message: "手机号码登录失败、跳转至账号登录", new { Error = -1 });
            }
            else
            {
                if (!string.IsNullOrEmpty(model.OpenId))//UnionId是否为空，为空则绑定手机号与UnionId
                {
                    if (OpenId != model.OpenId)
                    {
                        //return ApiResult.Failed("手机号与绑定的微信账户不一致", new { Error = 0 });
                    }
                }
                else
                {
                    model.UnionId = UnionId;
                    model.OpenId = OpenId;
                    accountService.UpdateAccountUnionId(model);
                }
                if (model.Status == Utility.Enum.DateStateEnum.Delete)
                {
                    return ApiResult.Failed(message: $"此账号【{ account }】已禁用", new { Error = 2 });
                }

                #region 获取进阶思维小程序端token
                TokenUserInfo UserInfo = new() { uid = model.Id.ToString(), requestFrom = Utility.Enum.ApiRequestFromEnum.MiniProgram };
                #region JWT
                IDateTimeProvider provider = new UtcDateTimeProvider();
                var now = provider.GetNow().AddMinutes(-1);
                var unixEpoch = new DateTime(1970, 1, 1, 0, 0, 0, DateTimeKind.Utc); // or use JwtValidator.UnixEpoch
                var secondsSinceEpoch = Math.Round((now - unixEpoch).TotalSeconds);
                var payload = new Dictionary<string, object>
                {
                        {"iat",secondsSinceEpoch },
                        {"exp",secondsSinceEpoch + Config.JwtExpirTime },
                        {"jjsw_userInfo", UserInfo }
                };
                IJwtAlgorithm algorithm = new HMACSHA256Algorithm();
                IJsonSerializer serializer = new JsonNetSerializer();
                IBase64UrlEncoder urlEncoder = new JwtBase64UrlEncoder();
                IJwtEncoder encoder = new JwtEncoder(algorithm, serializer, urlEncoder);
                string secret = Config.JwtSecretKey;
                string token = encoder.Encode(payload, secret);
                #endregion                
                #endregion

                Model.Cache.UserInfo obj = new Model.Cache.UserInfo
                {
                    Id = model.Id,
                    AccountType = model.AccountType,
                    AccountName = model.AccountName,
                    Token = token,
                    ApiRequestFromEnum = Utility.Enum.ApiRequestFromEnum.MiniProgram,
                    AccountId = model.AccountId,
                    UserMobile = model.Account,
                    UserIcon = model.UserIcon,
                };
                Cache.User.UserReidsCache.UserInfoSet(Cache.CacheKey.User_Login_Key + model.Id, obj, Config.JwtExpirTime);
                return ApiResult.Success(data: obj);
            }
        }

        #region 小程序获取手机号码
        /// <summary>
        /// 获取手机号码
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetGuestWeiXinMobile()
        {
            JObject parms = JObject.Parse(RequestParm.Msg.ToString());
            string code = parms.GetString("code");
            string encryptedData = parms.GetString("encryptedData");
            string iv = parms.GetString("iv");
            result res = new result()
            {
                phoneNumber = "",
                openid = ""
            };
            try
            {
                res = WeChatHelper.GetWechatMobile(encryptedData, code, iv);
            }
            catch
            {
                LogHelper.WriteError("GetGuestWeiXinMobile:1" + JsonHelper.Serialize(res));
                try
                {
                    res = WeChatHelper.GetWechatMobile(encryptedData, code, iv);
                }
                catch
                {
                    LogHelper.WriteError("GetGuestWeiXinMobile:2" + JsonHelper.Serialize(res));
                }
            }
            if (res.phoneNumber == null || string.IsNullOrEmpty(res.phoneNumber))
            {
                Thread.Sleep(10);
                try
                {
                    res = WeChatHelper.GetWechatMobile(encryptedData, code, iv);
                }
                catch
                {
                    LogHelper.WriteError("GetGuestWeiXinMobile:3" + JsonHelper.Serialize(res));
                    try
                    {
                        res = WeChatHelper.GetWechatMobile(encryptedData, code, iv);
                    }
                    catch
                    {
                        LogHelper.WriteError("GetGuestWeiXinMobile:4" + JsonHelper.Serialize(res));
                    }
                }
            }
            if (res.phoneNumber == null || string.IsNullOrEmpty(res.phoneNumber))
            {
                Thread.Sleep(10);
                try
                {
                    res = WeChatHelper.GetWechatMobile(encryptedData, code, iv);
                }
                catch
                {
                    LogHelper.WriteError("GetGuestWeiXinMobile:5" + JsonHelper.Serialize(res));
                    try
                    {
                        res = WeChatHelper.GetWechatMobile(encryptedData, code, iv);
                    }
                    catch
                    {
                        LogHelper.WriteError("GetGuestWeiXinMobile:6" + JsonHelper.Serialize(res));
                    }
                }
            }
            LogHelper.WriteError("GetGuestWeiXinMobile:7" + JsonHelper.Serialize(res));
            return ApiResult.Success("", res);
        }

        /// <summary>
        /// 获取用户信息
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetWeChatOpenId()
        {
            JObject parms = JObject.Parse(RequestParm.Msg.ToString());
            string code = parms.GetString("Code");

            result userinfo = WeChatHelper.GetWeChatOpenId(Config.AppID, Config.AppSecret, code);

            return ApiResult.Success(data: userinfo);
        }
        #endregion
    }
}
