﻿using EduSpider.IRepository;
using EduSpider.Model.Entity;
using EduSpider.Repository.Base;
using System.Collections.Generic;
using System.Linq;

namespace EduSpider.Repository
{
    public class StudentRepository : BaseRepository<RB_Student>, IStudentRepository
    {
        public bool BatchSetStudent(List<RB_Student> students)
        {
            bool flag;
            flag = base.BatchInsert(students, isReplace: true);
            return flag;
        }

        /// <summary>
        /// 获取学生列表 根据学生姓名
        /// </summary>
        /// <param name="stuNames"></param>
        /// <returns></returns>
        public List<RB_Student> GetListForStuName(string stuNames)
        {
            string sql = $"select StudId,StudentUid,StudentName from RB_Student where StudentName in({stuNames}) order by StudId desc";
            return Get<RB_Student>(sql).ToList();
        }
    }
}
