﻿using EduSpider.IRepository;
using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Model.Query;
using EduSpider.Repository.Base;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VTX.FW.DB;

namespace EduSpider.Repository
{
    /// <summary>
    /// 学员评语仓储接口实现
    /// </summary>
    public class StuCommentRepository : BaseRepository<RB_Stu_Comment>, IStuCommentRepository
    {
        /// <summary>
        /// 获取学员评语列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Stu_Comment> GetStuCommentListRepository(CourseQuery query)
        {
            StringBuilder builder = new();
            builder.AppendFormat(@"
SELECT A.*
FROM RB_Stu_Comment AS A
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}=0 ", nameof(RB_Stu_Comment.Status));
            if (query != null)
            {
                if (query.CourseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Stu_Comment.CourseId), query.CourseId);
                }
                if (!string.IsNullOrWhiteSpace(query.StuIds))
                {
                    builder.AppendFormat(" AND A.{0} IN({1}) ", nameof(RB_Stu_Comment.StuUid), query.StuIds);
                }
                if (query.HomeWorkId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Stu_Comment.HomeWorkId), query.HomeWorkId);
                }
                if (query.CommentTimes > 0)
                {
                    builder.AppendFormat(" AND A.{0} IN({1}) ", nameof(RB_Stu_Comment.Times), query.CommentTimes);
                }
            }
            return Get<RB_Stu_Comment>(builder.ToString()).ToList();
        }

        /// <summary>
        /// 新增修改学员评语
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetStuCommentRepository(RB_Stu_Comment model)
        {
            bool flag;
            if (model.Id > 0)
            {
                Dictionary<string, object> fileds = new()
                {
                    {nameof(RB_Stu_Comment.Info),model.Info },
                };
                flag = base.UpdateOne(fileds, new WhereHelper(nameof(RB_Stu_Comment.Id), model.Id));
            }
            else
            {
                var newId = base.Insert(model);
                model.Id = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 修改学员评论状态
        /// </summary>
        /// <param name="ShowType"></param>
        /// <param name="Ids"></param>
        /// <returns></returns>
        public bool SetStuCommentShowTypeRepository(int ShowType, string Ids)
        {
            string sql = string.Format("UPDATE RB_Stu_Comment SET ShowType={0} WHERE Id IN({1}) ", ShowType, Ids);
            return base.Execute(sql) > 0;
        }

        /// <summary>
        /// 根据课程评论次数修改可见等级
        /// </summary>
        /// <param name="CourseId">课程编号</param>
        /// <param name="Times">次数</param>
        /// <param name="ShowType">可见性</param>
        /// <returns></returns>
        public bool SetStuCommentShowTypeByTimesRepository(int CourseId, int Times, int ShowType)
        {
            string sql = string.Format("UPDATE RB_Stu_Comment SET ShowType={0} WHERE CourseId={1} AND  Times={2}", ShowType, CourseId, Times);
            return base.Execute(sql) > 0;
        }

        /// <summary>
        /// 根据编号删除学员评论
        /// </summary>
        /// <param name="Ids"></param>
        /// <returns></returns>
        public bool DeleteStuCommentRepository(string Ids)
        {
            string sql = string.Format("UPDATE RB_Stu_Comment SET Status=1 WHERE Id IN({0}) ",  Ids);
            return base.Execute(sql) > 0;
        }


        /// <summary>
        /// 获取系统生成评论次数 
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Stu_Comment> GetCourseCommentTimesListRepository(CourseQuery query)
        {
            StringBuilder builder = new();
            builder.AppendFormat(@"
SELECT A.Times,A.CourseId,MAX(CreateTime) AS CreateTime,CreateType
FROM RB_Stu_Comment AS A
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}=0 ", nameof(RB_Stu_Comment.Status));
            if (query != null)
            {
                if (query.CourseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Stu_Comment.CourseId), query.CourseId);
                }
                if (!string.IsNullOrWhiteSpace(query.StuIds))
                {
                    builder.AppendFormat(" AND A.{0} IN({1}) ", nameof(RB_Stu_Comment.StuUid), query.StuIds);
                }
                if (query.HomeWorkId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Stu_Comment.HomeWorkId), query.HomeWorkId);
                }
                if (query.CreateCommentType > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Stu_Comment.CreateType), query.CreateCommentType);
                }
            }
            builder.AppendFormat(@" GROUP BY A.Times,A.CourseId ");

            return Get<RB_Stu_Comment>(builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取评论列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Stu_Comment_Extend> GetStuCommentList(CourseQuery query)
        {
            StringBuilder builder = new();
            builder.AppendFormat(@"
SELECT A.*,s.StudentName as StuName
FROM RB_Stu_Comment AS A
left join rb_student s on A.StuUid = s.StudentUid
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}=0 ", nameof(RB_Stu_Comment.Status));
            if (query != null)
            {
                if (query.CourseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Stu_Comment.CourseId), query.CourseId);
                }
                if (!string.IsNullOrWhiteSpace(query.StuIds))
                {
                    builder.AppendFormat(" AND A.{0} IN({1}) ", nameof(RB_Stu_Comment.StuUid), query.StuIds);
                }
                if (query.HomeWorkId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Stu_Comment.HomeWorkId), query.HomeWorkId);
                }
                if (query.CommentTimes > 0)
                {
                    builder.AppendFormat(" AND A.{0} IN({1}) ", nameof(RB_Stu_Comment.Times), query.CommentTimes);
                }
            }
            return Get<RB_Stu_Comment_Extend>(builder.ToString()).ToList();
        }
    }
}
