﻿using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Model.Query;
using System.Collections.Generic;
using VTX.FW.Config;
using VTX.FW.DB;

namespace EduSpider.IRepository
{
    /// <summary>
    /// 学生评论详情仓储接口
    /// </summary>
    public interface IStuCommentDetailsRepository : IDBRepository<RB_Stu_CommentDetails>, IDependency
    {
        /// <summary>
        /// 批量新增修改学员评论详情
        /// </summary>
        /// <param name="list"></param>
        /// <returns></returns>
        public bool BatchSetStuCommentDetails(List<RB_Stu_CommentDetails> list);


        /// <summary>
        /// 获取学员评价详情
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Stu_CommentDetails_Extend> GetStuCommentDetailsListRepository(RB_Stu_CommentDetails_Extend query);

        /// <summary>
        /// 修改学生评价
        /// </summary>
        /// <param name="Ids"></param>
        /// <param name="Info"></param>
        /// <returns></returns>
        public bool SetStuCommentDetailsInfoRepository(string Ids, string Info);

        /// <summary>
        /// 修改学员评论状态
        /// </summary>
        /// <param name="ShowType"></param>
        /// <param name="Ids"></param>
        /// <returns></returns>
        public bool SetStuCommentDetailsShowTypeRepository(int ShowType, string Ids);

        /// <summary>
        /// 根据课程评论次数修改可见等级
        /// </summary>
        /// <param name="CourseId">课程编号</param>
        /// <param name="Times">次数</param>
        /// <param name="ShowType">可见性</param>
        /// <returns></returns>
        public bool SetStuCommentShowTypeByTimesRepository(int CourseId, int Times, int ShowType);

        /// <summary>
        /// 根据编号删除学员评论
        /// </summary>
        /// <param name="Ids"></param>
        /// <returns></returns>
        public bool DeleteStuCommentRepository(string Ids);
 
    }
}
