﻿using EduSpider.IRepository;
using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Model.Query;
using EduSpider.Repository.Base;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VTX.FW.DB;

namespace EduSpider.Repository
{
    /// <summary>
    /// 学员评价仓储接口实现
    /// </summary>
    public class StuCommentRepository : BaseRepository<RB_Stu_Comment>, IStuCommentRepository
    {
        /// <summary>
        /// 新增修改学员评语
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetStuCommentRepository(RB_Stu_Comment_Extend model,bool IsAdd=false)
        {
            bool flag = false;
            if (!IsAdd)
            {
                var oldModel = GetCourseCommentTimesListRepository(new CourseQuery() { CourseId = model.CourseId, CreateCommentType = model.CreateType, CommentTimes = model.Times }).FirstOrDefault();
                model.Id = oldModel?.Id ?? 0;
            }
            if (model.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Stu_Comment_Extend.CreateBy),model.CreateBy }
                };
                flag = base.UpdateOne(fileds, new WhereHelper(nameof(RB_Stu_Comment_Extend.Id), model.Id));
            }
            else
            {
                var newId = base.Insert(model);
                model.Id = newId;
                flag = newId > 0;
            }
            if (model.Details != null && model.Details.Count > 0)
            {
                foreach (var item in model.Details)
                {
                    item.CommentMainId = model.Id;
                }
                flag = new StuCommentDetailsRepository().BatchSetStuCommentDetails(model.Details);
            }
            return flag;
        }

        /// <summary>
        /// 获取作业评价次数列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Stu_Comment_Extend> GetCourseCommentTimesListRepository(CourseQuery query)
        {
            StringBuilder builder = new();
            builder.AppendFormat(@"
SELECT A.*
FROM RB_Stu_Comment AS A
WHERE 1=1
");
            if (query != null)
            {
                if (query.CourseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Stu_Comment_Extend.CourseId), query.CourseId);
                }
                if (query.CommentTimes > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Stu_Comment_Extend.Times), query.CommentTimes);
                }
                if (query.CreateCommentType > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Stu_Comment_Extend.CreateType), query.CreateCommentType);
                }
            }
            return Get<RB_Stu_Comment_Extend>(builder.ToString()).ToList();
        }

        /// <summary>
        /// 批量添加学员评价
        /// </summary>
        /// <param name="model"></param>
        /// <param name="commentType"></param>
        /// <returns></returns>
        public bool BatchSetStuCommentRepository(RB_Stu_Comment_Extend model, StuCommentType commentType)
        {
            bool flag = false;
            // 以前批量添加接口
            if (commentType != null)
            {
                if (commentType.CommentType == 2)
                {
                    flag = AddTemplateStuComment(model, commentType.IsDefault, commentType.CommentId);
                }
                else
                {
                    flag = SetStuCommentRepository(model);
                }
            }
            else
            {
                flag = SetStuCommentRepository(model);
            }
            return flag;
        }

        /// <summary>
        /// 根据模板生成评价
        /// </summary>
        /// <param name="list"></param>
        /// <param name="IsDefault"></param>
        /// <param name="CommentId"></param>
        /// <returns></returns>
        private bool AddTemplateStuComment(RB_Stu_Comment_Extend model, int IsDefault, int CommentId)
        {
            bool flag = false;
            if (model != null  )
            {
                var homeworkList = new StuHomeWorkRepository().GetStuHomeWorkDetailsListRepository(new CourseQuery()
                {
                    CourseId = model.CourseId,
                    QHomeWorkIds= model.Details[0].HomeWorkIds,
                });
                if (homeworkList != null && homeworkList.Count > 0)
                {
                    var courseComment = new RB_Course_Comment_Extend();
                    var defaultComment = new RB_Comment_Extend();
                    if (IsDefault == 1)
                    {
                        defaultComment = new CommentRepository().GetCommentListRepository(new CourseQuery() { DefaultCommentId = CommentId }).FirstOrDefault();
                    }
                    else
                    {
                        courseComment = new CourseCommentRepository().GetCourseCommentListRepository(new CourseQuery() { CourseId = model.CourseId }).Where(qitem => qitem.Id == CommentId).FirstOrDefault();
                    }
                    foreach (var item in model.Details)
                    {
                        var tempList = homeworkList.Where(qitem => qitem.student_uid == item.StuUid).ToList();
                        item.CreateTime = tempList.LastOrDefault().add_time.AddSeconds(1);
                        var Score = tempList.Average(qitem => qitem.score_p) * 100;
                        string info = "";
                        if (IsDefault == 1)
                        {
                            if (defaultComment != null && defaultComment.Details != null && defaultComment.Details.Count > 0)
                            {
                                var tempModel = defaultComment.Details.Where(qitem => qitem.StartNum <= Score && Score < qitem.EndNum)?.FirstOrDefault();
                                if (tempModel != null)
                                {
                                    info = tempModel?.Info ?? "";
                                }
                            }
                        }
                        else
                        {
                            if (courseComment != null && courseComment.CommentDetails != null && courseComment.CommentDetails.Count > 0)
                            {
                                var tempModel = courseComment.CommentDetails.Where(qitem => qitem.StartNum <= Score && Score < qitem.EndNum)?.FirstOrDefault();
                                if (tempModel != null)
                                {
                                    info = tempModel?.Info ?? "";
                                }
                            }
                        }
                        item.Info = info;

                    }
                }
            }
            flag = SetStuCommentRepository(model,IsAdd:true);
            return flag;
        }
    }
}
