﻿using EduSpider.Utility.Enum;
using System.Collections.Generic;

namespace EduSpider.Model.Cache
{
    /// <summary>
    /// 用户缓存
    /// </summary>
    public class UserInfo
    {
        /// <summary>
        /// 唯一Key
        /// </summary>
        public int UniqueId { get; set; }

        /// <summary>
        /// 对应  teacherId / stuId
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 账号名称
        /// </summary>
        public string AccountName { get; set; }

        /// <summary>
        /// 请求来源
        /// </summary>
        public ApiRequestFromEnum ApiRequestFromEnum { get; set; }

        /// <summary>
        /// 账号类型(1-管理端，2,-教师端，3-助教，4-学生)
        /// </summary>
        public AccountTypeEnum AccountType { get; set; }

        /// <summary>
        /// 对应 老师/学生 UId
        /// </summary>
        public int AccountId { get; set; }

        /// <summary>
        /// Token验证
        /// </summary>
        public string Token { get; set; }

        /// <summary>
        /// 用户头像
        /// </summary>
        public string UserIcon { get; set; }

        /// <summary>
        /// 用户手机号码
        /// </summary>
        public string UserMobile { get; set; }

    }
}