﻿using EduSpider.Utility.Enum;
using System;
using VTX.FW.Attr;

namespace EduSpider.Model.Entity
{
    /// <summary>
    /// 课程实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Course
    {
        /// <summary>
        /// 课程编号
        /// </summary>
        public int CourseId { get; set; }

        /// <summary>
        /// 课程名称
        /// </summary>
        public string CourseName { get; set; }

        /// <summary>
        /// 首次课日期
        /// </summary>
        public DateTime BeginTime { get; set; }

        /// <summary>
        /// 完成次数
        /// </summary>
        public int CompleteNum { get; set; }

        /// <summary>
        /// 总次数
        /// </summary>
        public int TotalClassNum { get; set; }

        /// <summary>
        /// 有效日期
        /// </summary>
        public DateTime? ExpiryTime { get; set; }

        /// <summary>
        /// 直播数
        /// </summary>
        public int? LiveNum { get; set; }

        /// <summary>
        /// 录课数
        /// </summary>
        public int? RecordNum { get; set; }

        /// <summary>
        /// 回放数
        /// </summary>
        public int? OpenNum { get; set; }

        /// <summary>
        /// 学生数
        /// </summary>
        public int? StudentNum { get; set; }

        /// <summary>
        /// 旁听数
        /// </summary>
        public int AuditNum { get; set; }

        /// <summary>
        /// 教师数
        /// </summary>
        public int TeacherNum { get; set; }

        /// <summary>
        /// 课程状态(1-未结课，课程进度未完成,3-已结课)
        /// </summary>
        public int CourseStatus { get; set; }

        /// <summary>
        /// 回放地址
        /// </summary>
        public string WebCast { get; set; }

        /// <summary>
        /// 班主任编号
        /// </summary>
        public int TeacherId { get; set; }

        /// <summary>
        /// 班主任账号
        /// </summary>
        public string TeacherAccount { get; set; }

        /// <summary>
        /// 班主任账号Id
        /// </summary>
        public int? TeacherUid { get; set; }

        /// <summary>
        /// 班主任姓名
        /// </summary>
        public string TeacherName { get; set; }

        /// <summary>
        /// 班主任头像
        /// </summary>
        public string TeacherLogo { get; set; }

        /// <summary>
        /// 课程类型(1-标准课，公开课)
        /// </summary>
        public int CourseType { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime AddTime { get; set; }

        /// <summary>
        /// 课程图片
        /// </summary>
        public string CourseWare { get; set; }

        /// <summary>
        /// 封面图
        /// </summary>
        public string CoverImg { get; set; }
    }
}
