﻿using System;
using VTX.FW.Attr;

namespace EduSpider.Model.Entity
{
    /// <summary>
    /// 学员评语实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Stu_Comment
    {
        /// <summary>
        /// 主键编号
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 家庭作业编号
        /// </summary>
        public int HomeWorkId { get; set; }

        /// <summary>
        /// 学员登录编号
        /// </summary>
        public int StuUid { get; set; }

        /// <summary>
        /// 课程编号
        /// </summary>
        public int CourseId { get; set; }

        /// <summary>
        /// 评语次数
        /// </summary>
        public int Times { get; set; }

        /// <summary>
        /// 评语
        /// </summary>
        public string Info { get; set; }

        /// <summary>
        /// 创建类型(1-系统创建，2-老师创建)
        /// </summary>
        public int CreateType { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateTime { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// 创建人姓名
        /// </summary>
        public string CreateByName { get; set; }

        /// <summary>
        /// 显示类型(1-全部可见，2-部分可见，3-不可见)
        /// </summary>
        public int ShowType { get; set; }

        /// <summary>
        /// 删除状态(0-正常，1-删除)
        /// </summary>
        public int Status { get; set; }
    }
}
