﻿using EduSpider.IServices;
using Microsoft.Extensions.Hosting;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using VTX.FW.Attr;

namespace EduSpider.WebApi.Timers
{
    /// <summary>
    /// 定时任务
    /// </summary>
    public class TimedTaskServices : IHostedService, IDisposable
    {

        /// <summary>
        /// 课程仓储接口
        /// </summary>
        [Autowired]
        public ICourseService CourseService { get; set; }

        //定义一个定时器
        private Timer _timer;

  

        private static int create_Comment = 0;

        public Task StartAsync(CancellationToken cancellationToken)
        {
            VTX.FW.Helper.LogHelper.WriteInfo("StartAsync","定时任务被启动");
            int Interval = 0;
            Interval = 2;
            //Interval = 1;
            //绑定定时任务
            //设置延迟时间
            _timer = new Timer(DoWork, null, TimeSpan.Zero, TimeSpan.FromSeconds(60 * Interval));
            return Task.CompletedTask;
        }


        public Task StopAsync(CancellationToken cancellationToken)
        {
            VTX.FW.Helper.LogHelper.WriteInfo("StopAsync", "定时任务被关闭");
            _timer?.Change(Timeout.Infinite, 0);
            return Task.CompletedTask;
        }

        /// <summary>
        /// 定时生成市场部和课程顾问部数据统计
        /// </summary>
        /// <param name="state"></param>
        /// <returns></returns>
        private void DoWork(object state)
        {
            VTX.FW.Helper.LogHelper.WriteInfo("DoWork","定时任务被触发");
            try
            {
                if (Interlocked.Exchange(ref create_Comment, 1) == 0)
                {
                    VTX.FW.Helper.LogHelper.WriteInfo("DoWork", "DealMarketConsultantData========Start");
                    var today = DateTime.Now;
                    CourseService.CreateHomeWorkComment(0);
                    VTX.FW.Helper.LogHelper.WriteInfo("DoWork", "DealMarketConsultantData========End");
                    Interlocked.Exchange(ref create_Comment, 0);
                }
            }
            catch (Exception ex)
            {
                VTX.FW.Helper.LogHelper.WriteError("DoWork", "定时任务异常", ex);
            }
        }

        public void Dispose()
        {
            VTX.FW.Helper.LogHelper.WriteInfo("Dispose", "定时任务被释放闭");
            _timer?.Dispose();
            //iis会回收这个定时任务，这边在回收的时候触发一个请求，来再次唤醒该服务
            Thread.Sleep(5000);
            string url = "https://jjswapi.oytour.com/api/login/Heart";
            VTX.FW.Helper.HttpHelper.HttpGet(url);
        }
    }
}
