﻿using EduSpider.IRepository;
using EduSpider.Model.Entity;
using EduSpider.Repository.Base;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EduSpider.Repository
{
    /// <summary>
    /// 默认评论详情接口
    /// </summary>
    public class CommentDetailsRepository : BaseRepository<RB_Comment_Details>, ICommentDetailsRepository
    {
        /// <summary>
        /// 批量新增默认规则详情
        /// </summary>
        /// <param name="list"></param>
        /// <returns></returns>
        public bool BatchSetCommentDetailsRepository(List<RB_Comment_Details> list)
        {
            bool flag = false;
            flag = base.BatchInsert(list);
            return flag;
        }


        /// <summary>
        /// 获取默认规则详情列表
        /// </summary>
        /// <param name="CommentIds"></param>
        /// <returns></returns>
        public List<RB_Comment_Details> GetCommentDetailsListRepository(string CommentIds)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(@"
SELECT A.*
FROM  RB_Comment_Details AS A
WHERE 1=1
");
            if (!string.IsNullOrEmpty(CommentIds))
            {
                builder.AppendFormat(@" AND A.{0} IN ({1}) ", nameof(RB_Comment_Details.CommentId), CommentIds);
            }
            return Get<RB_Comment_Details>(builder.ToString()).ToList();
        }
    }
}
