﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Linq;
using System.ServiceProcess;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using TicketSpider.Spiders.ClassInRule;

namespace EduSpider
{
    partial class MindService : ServiceBase
    {
        System.Timers.Timer timer1;  //计时器
        public MindService()
        {
            InitializeComponent();
        }

        protected override void OnStart(string[] args)
        {
            VTX.FW.Helper.LogHelper.WriteInfo("OnStart", "开始服务");
            timer1 = new System.Timers.Timer();
            timer1.Interval = 1000 * 60 * 1; //60分钟
            timer1.Elapsed += new System.Timers.ElapsedEventHandler(RunClassInData);
            timer1.Enabled = true;
        }

        private static int inTimer = 0;

        /// <summary>
        /// 收入单子服务开始执行方法
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void RunClassInData(object sender, System.Timers.ElapsedEventArgs e)
        {
            if (Interlocked.Exchange(ref inTimer, 1) == 0)
            {
                VTX.FW.Helper.LogHelper.WriteInfo("RunClassInData", "开始ClassIn数据");
                new ClassInFlow().StartAsync();
                Interlocked.Exchange(ref inTimer, 0);
                VTX.FW.Helper.LogHelper.WriteInfo("RunClassInData", "结束ClassIn数据");
            }
        }

        protected override void OnStop()
        {
            this.timer1.Enabled = false;
        }
    }
}
