﻿using EduSpider.IRepository;
using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Repository.Base;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VTX.FW.DB;
using VTX.FW.DB.Dapper;

namespace EduSpider.Repository
{
    /// <summary>
    /// 默认评论仓储接口实现
    /// </summary>
    public class CommentRepository : BaseRepository<RB_Comment>, ICommentRepository
    {
        /// <summary>
        /// 默认评论详情接口
        /// </summary>
        ICommentDetailsRepository commentDetailsRepository = new CommentDetailsRepository();

        /// <summary>
        /// 新增修改默认配置
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetCommentRepository(RB_Comment_Extend model)
        {
            bool flag = false;
            if (model.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Comment_Extend.KeyWords),model.KeyWords.Trim() }
                };
                flag = base.UpdateOne(fileds, new WhereHelper(nameof(RB_Comment_Extend.Id), model.Id));
            }
            else
            {
                var newId = base.Insert(model);
                model.Id = newId;
                flag = newId > 0;
            }
            if (model.Details != null && model.Details.Count > 0)
            {
                foreach (var item in model.Details)
                {
                    item.CommentId = model.Id;
                }
                commentDetailsRepository.BatchSetCommentDetailsRepository(model.Details);
            }
            return flag;
        }

        /// <summary>
        /// 获取评语
        /// </summary>
        /// <param name="Score"></param>
        /// <returns></returns>
        public RB_Comment_Extend GetComment(decimal Score)
        {
            StringBuilder builder = new();
            builder.AppendFormat(@"
SELECT A.*
FROM RB_Comment AS A
WHERE 1=1
");
            if (Score > 0)
            {
                builder.AppendFormat(@" AND A.StartNum<{0} AND {0}<=A.EndNum ", Score);
            }
            else
            {
                builder.AppendFormat(@" AND A.StartNum<={0} AND {0}<=A.EndNum ", Score);
            }

            return base.Get<RB_Comment_Extend>(builder.ToString()).ToList().FirstOrDefault();
        }

        /// <summary>
        /// 获取系统配置评价列表
        /// </summary>
        /// <returns></returns>
        public RB_Comment_Extend GetCommentListRepository(string KeyWords,int CommentTimes)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new();
            builder.AppendFormat(@"
SELECT A.*
FROM RB_Comment AS A
WHERE 1=1
");
            if (!string.IsNullOrEmpty(KeyWords))
            {
                if (KeyWords.Contains("高中"))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @KeyWords1 ",nameof(RB_Comment_Extend.KeyWords));
                    parameters.Add("KeyWords1", "高中");
                }
                if (KeyWords.Contains("初中"))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @KeyWords2 ", nameof(RB_Comment_Extend.KeyWords));
                    parameters.Add("KeyWords2", "初中");
                }
                if (KeyWords.Contains("化学"))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @KeyWords3 ", nameof(RB_Comment_Extend.KeyWords));
                    parameters.Add("KeyWords3", "化学");
                }
                if (KeyWords.Contains("数学"))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @KeyWords4 ",nameof(RB_Comment_Extend.KeyWords));
                    parameters.Add("KeyWords4", "数学");
                }
            }
            if (CommentTimes > 0)
            {
                builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Comment_Extend.Times), CommentTimes);
            }
            var model = base.Get<RB_Comment_Extend>(builder.ToString()).ToList().FirstOrDefault();
            if (model != null && model.Id>0)
            {
                string Ids = model.Id.ToString();
                List<RB_Comment_Details> subList = new List<RB_Comment_Details>();
                if (!string.IsNullOrEmpty(Ids))
                {
                    subList = commentDetailsRepository.GetCommentDetailsListRepository(Ids);
                }
                model.Details = subList?.Where(qitem => qitem.CommentId == model.Id)?.OrderBy(qitem => qitem.StartNum)?.ToList();
            }
            return model;
        }
    }
}
