﻿using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Net.Http;
using System.Text;
using VTX.FW.Helper;


namespace EduSpider.Utility
{
    /// <summary>
    /// Http请求帮助类
    /// </summary>
    public class HttpHelper
    {
        public static HttpClient GenerateHttp()
        {
            var handler = new HttpClientHandler();
            handler.AllowAutoRedirect = false;
            handler.UseCookies = true;
            handler.CookieContainer = CreateCookie();
            handler.AutomaticDecompression = DecompressionMethods.GZip;
            handler.ClientCertificateOptions = ClientCertificateOption.Automatic;
            var http = new HttpClient(handler);
            GenerateHttpHeader(ref http);

            return http;
        }

        private static void GenerateHttpHeader(ref HttpClient http)
        {
            http.DefaultRequestHeaders.Add("Accept", "application/json, text/plain, */*");
            http.DefaultRequestHeaders.Add("Accept-Encoding", "gzip, deflate, br");
            http.DefaultRequestHeaders.Add("Accept-Language", "zh-CN,zh;q=0.9,ja;q=0.8");
            http.DefaultRequestHeaders.Add("Cache-Control", "no-cache");
            http.DefaultRequestHeaders.Add("Origin", "https://console.eeo.cn");
            http.DefaultRequestHeaders.Add("Pragma", "no-cache");
            http.DefaultRequestHeaders.Add("Referer", "https://console.eeo.cn/saas/school/index.html");
            http.DefaultRequestHeaders.Add("salesChannel", "NzcwMQ==");
            http.DefaultRequestHeaders.Add("sec-ch-ua", "\" Not; A Brand\";v=\"99\", \"Google Chrome\";v=\"97\", \"Chromium\";v=\"97\"");
            http.DefaultRequestHeaders.Add("sec-ch-ua-mobile", "?0");
            http.DefaultRequestHeaders.Add("sec-ch-ua-platform", "\"Windows\"");
            http.DefaultRequestHeaders.Add("Sec-Fetch-Dest", "empty");
            http.DefaultRequestHeaders.Add("Sec-Fetch-Mode", "cors");

            http.DefaultRequestHeaders.Add("Sec-Fetch-Site", "same-origin");
            http.DefaultRequestHeaders.Add("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.99 Safari/537.36");


            http.DefaultRequestHeaders.Add("site", "zh_CN");
            http.DefaultRequestHeaders.Add("shakehand", "535206fb27efbaf75066ff179b975ff6");
            http.DefaultRequestHeaders.Add("pragma", "no-cache");
        }

        private static CookieContainer CreateCookie()
        {
            var cookieStr = "sajssdk_2015_cross_new_user=1; PHPSESSID=2mvvd4h9hmvs9gvmv3ego8t167; _eeos_uid=12780052; _eeos_useraccount=18140082327; _eeos_userlogo=%2Fupload%2Fimages%2F20200126%2F709df9532bee722f2268_70.jpg; _eeos_domain=.eeo.cn; _eeos_remember=1; _eeos_traffic=EqlIOFq4S2hz5FTTtHzNUViBYcWCixrJYMCF6Y5yJuD8eq8ZwPvVSHMvUkLFA5lzNoaTrDBpGhFOuRmo3R6CQ4pXDRdN9nKnxel4M3FHU3U%3D; _eeos_sid=12780052; _eeos_nsid=kspGu2gfMu%2BU2EFgLpSGyg%3D%3D; locationArgumentLang=zh-CN; sensorsdata2015jssdkcross=%7B%22distinct_id%22%3A%2212780052%22%2C%22first_id%22%3A%22180f59907abbed-081e4952c5b26f-12333272-2073600-180f59907acbc8%22%2C%22props%22%3A%7B%22%24latest_traffic_source_type%22%3A%22%E7%9B%B4%E6%8E%A5%E6%B5%81%E9%87%8F%22%2C%22%24latest_search_keyword%22%3A%22%E6%9C%AA%E5%8F%96%E5%88%B0%E5%80%BC_%E7%9B%B4%E6%8E%A5%E6%89%93%E5%BC%80%22%2C%22%24latest_referrer%22%3A%22%22%7D%2C%22%24device_id%22%3A%22180f59907abbed-081e4952c5b26f-12333272-2073600-180f59907acbc8%22%7D; __tk_id=afefff800c5a030d578e4bddba2a0914";
            var uri = new Uri("https://console.eeo.cn");
            var cc = new CookieContainer();

            foreach (var str in cookieStr.Split(';'))
            {
                cc.SetCookies(uri, str);
            }
            return cc;
        }
    }
}