﻿using EduSpider.IServices;
using EduSpider.Model.Extend;
using EduSpider.WebApi.Controllers.Base;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Collections.Generic;
using System.Linq;
using VTX.FW.Api;
using VTX.FW.Attr;
using VTX.FW.Helper;

namespace EduSpider.WebApi.Controllers
{
    /// <summary>
    /// 考试控制器
    /// </summary>
    public class ExamController : BaseController
    {
        /// <summary>
        /// 考试
        /// </summary>
        [Autowired]
        public IExamService ExamService { get; set; }

        /// <summary>
        /// 获取考试分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetExamPageList()
        {            
            ResultPageModel pmodel = JsonHelper.Deserialize<ResultPageModel>(RequestParm.Msg.ToString());
            RB_Exam_Extend demodel = JsonHelper.Deserialize<RB_Exam_Extend>(RequestParm.Msg.ToString());

            var list = ExamService.GetExamPageList(pmodel.PageIndex, pmodel.PageSize, out long count, demodel);
            pmodel.RowsCount = count;
            pmodel.PageData = list.Select(x => new
            {
                x.ExamId,
                x.ExamName,
                x.CourseId,
                x.StuNum,
                x.FailNum,
                x.TScore,
                AvgScore = x.StuNum > 0 ? Math.Round(x.TScore / x.StuNum, 2, MidpointRounding.AwayFromZero) : 0,
                CreateTime = x.CreateTime.ToString("yyyy-MM-dd HH:mm")
            });
            return ApiResult.Success("", pmodel);
        }

        /// <summary>
        /// 获取考试学生列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetExamStuList() {
            RB_Exam_Score_Extend demodel = JsonHelper.Deserialize<RB_Exam_Score_Extend>(RequestParm.Msg.ToString());
            if (demodel.ExamId <= 0)
            {
                return ApiResult.ParamIsNull();
            }
            var list = ExamService.GetExamStuList(demodel);
            return ApiResult.Success("", list.Select(x => new
            {
                x.Id,
                x.ExamId,
                x.StuId,
                x.StuUId,
                x.StuName,
                x.TScore,
                x.ExamScore,
                ScoreRate = Math.Round(x.TScore / x.ExamScore, 2, MidpointRounding.AwayFromZero),
                x.Rank,
                x.RankRate
            }));            
        }

        /// <summary>
        /// 获取学生考试明细
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetExamStuScoreInfo() {
            int ExamId = ReqParameters.GetInt("ExamId");//考试ID
            int StuId = ReqParameters.GetInt("StuId");//学生id
            int StuUId = ReqParameters.GetInt("StuUId");//学生Uid

            if (ExamId <= 0 || (StuId <= 0 && StuUId <= 0))
            {
                return ApiResult.ParamIsNull();
            }

            var robj = ExamService.GetExamStuScoreInfo(ExamId, StuId, StuUId);
            return ApiResult.Success("", robj);
        }

        /// <summary>
        /// 删除考试
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DelExamInfo() {
            int ExamId = ReqParameters.GetInt("ExamId");//考试ID
            if (ExamId <= 0)
            {
                return ApiResult.ParamIsNull("请传递考试ID");
            }
            if (UserInfo.AccountType != Utility.Enum.AccountTypeEnum.Teacher)
            {
                return ApiResult.ParamIsNull("非老师账户，无法操作");
            }

            string rmsg = ExamService.DelExamInfo(ExamId, base.UserInfo.Id);
            if (rmsg == "")
            {
                return ApiResult.Success();
            }
            else {
                return ApiResult.Failed(rmsg);
            }
        }

    }
}
