﻿using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using VTX.FW.Helper;

namespace EduSpider.Spiders.SchoolHouseKeeper
{
    /// <summary>
    /// 校管家课程关联
    /// </summary>
    public class SchoolCourseManager
    {
        /// <summary>
        /// 分页数据
        /// </summary>
        public class PageModel
        {
            public int PageIndex { get; set; }
            public int PageSize { get; set; }
        }

        /// <summary>
        /// 获取课程列表
        /// </summary>
        public static async void RunCourse(string cookie)
        {
            var pageModel = new PageModel
            {
                PageIndex = 1,
                PageSize = 10
            };
            int pageCount, totalCount;
            string url = "https://tms11.xiaogj.com/api/Shift/Query";
            string result;
            result = Utility.SchoolHttpHelper.HttpPost(url, VTX.FW.Helper.JsonHelper.Serialize(pageModel), "application/json", cookie); ;
            List<SchoolCourseItem> list = new();
            if (!string.IsNullOrEmpty(result))
            {
                JObject jobj = JObject.Parse(result);
                pageCount = jobj.GetInt("PageCount");
                totalCount = jobj.GetInt("TotalCount");
                list.AddRange(ParseJson(jobj.GetString("Data")));
                Console.WriteLine(string.Format("已完成 第 {0} 页/共 {1} 页,已完成 {2} 条/总共 {3} 条", pageModel.PageIndex, pageCount, pageModel.PageSize * pageModel.PageIndex, totalCount));
                if (pageCount > pageModel.PageIndex)
                {
                    Random random = new();
                    for (var i = 2; i <= pageCount; i++)
                    {
                        var num = random.Next(1, 10);
                        Thread.Sleep(1000 * num);
                        pageModel.PageIndex = i;
                        string subResult = Utility.SchoolHttpHelper.HttpPost(url, VTX.FW.Helper.JsonHelper.Serialize(pageModel), "application/json", cookie);
                        if (!string.IsNullOrEmpty(subResult))
                        {
                            JObject subObj = JObject.Parse(subResult);
                            list.AddRange(ParseJson(subObj.GetString("Data")));
                        }
                        Console.WriteLine(string.Format("已完成 第 {0} 页/共 {1} 页,已完成 {2} 条/总共 {3} 条", pageModel.PageIndex, pageCount, pageModel.PageSize * pageModel.PageIndex, totalCount));
                    }
                }
            }
            Console.WriteLine("result:" + VTX.FW.Helper.JsonHelper.Serialize(list));

        }

        /// <summary>
        /// 解析JSON
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static List<SchoolCourseItem> ParseJson(string data)
        {
            List<SchoolCourseItem> list = new();
            if (!string.IsNullOrEmpty(data))
            {
                JArray courseArray = JArray.Parse(data);
                if (courseArray != null && courseArray.Count > 0)
                {
                    foreach (var item in courseArray)
                    {
                        JObject cObj = JObject.Parse(item.ToString());

                        var model = new SchoolCourseItem()
                        {
                            ID = cObj.GetString("ID"),
                            Name = cObj.GetString("Name"),
                            IsOneToOne = cObj.GetInt("IsOneToOne"),
                        };
                        list.Add(model);
                    }
                }
            }
            return list;
        }
    }

    /// <summary>
    /// 校管家课程实体
    /// </summary>
    public class SchoolCourseItem
    {
        /// <summary>
        /// 课程编号GUID
        /// </summary>
        public string ID { get; set; }

        /// <summary>
        /// 课程名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 是否一对一
        /// </summary>
        public int IsOneToOne { get; set; }

        public string ShiftTypeName { get; set; }

        public string Unit { get; set; }

        public int UnitCode { get; set; }

        public string OriginalUnit { get; set; }

        public string FormatedTermUnit { get; set; }

        public int IsByTerm { get; set; }

        public int CourseAmountPerTerm { get; set; }

        public decimal TermPrice { get; set; }

        public decimal UnitPrice { get; set; }

        public string SubjectID { get; set; }

        public string Describe { get; set; }

        public int Order { get; set; }

        public int Status { get; set; }

        public string GradeName { get; set; }

        public string SubjectName { get; set; }

        public string CategoryName { get; set; }

        public int CampusCountPermit { get; set; }

        public int EnableSubject { get; set; }

        public int ConsumeAmount { get; set; }

        public int IsDynamicConsume { get; set; }

        public int MinutesToTimes { get; set; }

        public int StandardMinutes { get; set; }

        public int CourseTimes { get; set; }

        public string ClassTypeName { get; set; }

        public int Year { get; set; }

        public string Term { get; set; }

        public string TermName { get; set; }

        public int EnableShiftSpec { get; set; }

        public decimal Price { get; set; }

        public string ProductType { get; set; }

        public decimal ShiftTotalPrice { get; set; }

        public decimal ExportUnitPrice { get; set; }

        public int NumberOfStudents { get; set; }

        public int DateType { get; set; }

        public string DateValue { get; set; }

        public int UnitPriceByTerm { get; set; }

        public int ShiftSpecRegion { get; set; }

        public int MinStudentsAmount { get; set; }

        public int IsDrainageClass { get; set; }
    }
}
