﻿using EduSpider.Model.Entity;
using EduSpider.Repository;
using EduSpider.Utility.Enum;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http;
using System.Text;
using System.Threading;
using VTX.FW.Helper;

namespace EduSpider.Spiders.ClassInRule
{
    /// <summary>
    /// 课程关联
    /// </summary>
    public class CourseManager
    {
        /// <summary>
        /// 获取课程列表
        /// </summary>
        public async void RunCourse(string cookie)
        {
            int perpage = 20;
            var pageCount = 1;
            var request = Utility.HttpHelper.GenerateHttp(cookie);
            string queryStr = "page={0}&perpage={1}";
            string paramStr = string.Format(queryStr, pageCount, perpage);
            var content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/x-www-form-urlencoded");
            ICourseRepository courseRepository = new CourseRepository();
            int totalCount = 0;
            Console.WriteLine(string.Format("开始第{0}次获取课程数据", pageCount));
            var response = await request.PostAsync("https://console.eeo.cn/saasajax/course.ajax.php?action=getCourseList", content);
            var result = response.Content.ReadAsStringAsync().Result;
            if (!string.IsNullOrWhiteSpace(result))
            {
                JObject rootObj = JObject.Parse(result);
                if (!string.IsNullOrWhiteSpace(rootObj.GetString("data")))
                {
                    JObject dataObj = JObject.Parse(rootObj.GetString("data"));
                    var totalNum = dataObj.GetInt("totalCourseNum");
                    var tempList = ParseJson(dataObj.GetString("courseList"));
                    if (tempList != null && tempList.Count > 0)
                    {
                        courseRepository.BatchSetCourseRepository(tempList);
                        totalCount += tempList.Count();
                        Console.WriteLine(string.Format("第{0}次,导入完成{1}条.", pageCount,totalCount));
                        foreach (var item in tempList)
                        {
                            RunCourseStudent(cookie, item.courseId);
                        }
                    }
                    if (totalNum % perpage == 0)
                    {
                        pageCount = totalNum / perpage;
                    }
                    else
                    {
                        pageCount = totalNum / perpage + 1;
                    }
                    if (totalNum > perpage)
                    {
                        for (var i = 2; i <= pageCount; i++)
                        {
                            Thread.Sleep(1000 * 2);
                            Console.WriteLine(string.Format("第{0}/{1}次获取课程数据", i, pageCount));
                            paramStr = string.Format(queryStr, i, perpage);
                            var sub_content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/x-www-form-urlencoded");
                            var sub_response = await request.PostAsync("https://console.eeo.cn/saasajax/course.ajax.php?action=getCourseList", sub_content);

                            var sub_result = sub_response.Content.ReadAsStringAsync().Result;
                            if (!string.IsNullOrWhiteSpace(sub_result))
                            {
                                JObject sub_rootObj = JObject.Parse(sub_result);
                                if (!string.IsNullOrWhiteSpace(sub_rootObj.GetString("data")))
                                {
                                    JObject sub_dataObj = JObject.Parse(sub_rootObj.GetString("data"));
                                    var subtempList = ParseJson(sub_dataObj.GetString("courseList"));
                                    if (subtempList != null && subtempList.Count > 0)
                                    {
                                        courseRepository.BatchSetCourseRepository(subtempList);
                                        totalCount += subtempList.Count();
                                        Console.WriteLine(string.Format("第{0}次,导入完成{1}条.", i, totalCount));
                                        foreach (var sItem in subtempList)
                                        {
                                            RunCourseStudent(cookie, sItem.courseId);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }

        }

        /// <summary>
        /// JSON字符串转课程列表
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public List<RB_Course> ParseJson(string data)
        {
            List<RB_Course> list = new List<RB_Course>();
            JArray courseArray = JArray.Parse(data);
            if (courseArray != null && courseArray.Count > 0)
            {
                foreach (var jItem in courseArray)
                {
                    JObject courseObj = JObject.Parse(jItem.ToString());
                    var expiryTime = ConvertHelper.UnixToDateTime(courseObj.GetInt("expiryTime"));
                    if (ConvertHelper.FormatTime(expiryTime) == "1970-01-01 08:00:00")
                    {
                        expiryTime = new DateTime(0001, 01, 01);
                    }
                    list.Add(new RB_Course()
                    {
                        courseId = courseObj.GetInt("courseId"),
                        courseName = courseObj.GetString("courseName"),
                        beginTime = ConvertHelper.UnixToDateTime(courseObj.GetInt("beginTime")),
                        completeNum = courseObj.GetInt("completeNum"),
                        totalClassNum = courseObj.GetInt("totalClassNum"),
                        expiryTime = expiryTime,
                        liveNum = courseObj.GetInt("liveNum"),
                        recordNum = courseObj.GetInt("recordNum"),
                        openNum = courseObj.GetInt("openNum"),
                        studentNum = courseObj.GetInt("studentNum"),
                        auditNum = courseObj.GetInt("auditNum"),
                        teacherNum = courseObj.GetInt("teacherNum"),
                        courseStatus = (CourseStatusEnum)courseObj.GetInt("courseStatus"),
                        webCast = courseObj.GetString("webCast"),
                        teacherId = courseObj.GetInt("teacherId"),
                        teacherAccount = courseObj.GetString("teacherAccount"),
                        teacherUid = courseObj.GetInt("teacherUid"),
                        teacherName = courseObj.GetString("teacherName"),
                        teacherLogo = courseObj.GetString("teacherLogo"),
                        courseType = (CourseTypeEnum)courseObj.GetInt("courseType"),
                    }); ;
                }
            }
            return list;
        }

        /// <summary>
        /// 获取课程学员列表
        /// </summary>

        public async void RunCourseStudent(string cookie,int courseId)
        {
            var request = Utility.HttpHelper.GenerateHttp(cookie);
            string queryStr = "courseId={0}";
            string paramStr = string.Format(queryStr, courseId);
            var content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/x-www-form-urlencoded");
            ICourseStudentRepository courseStudentRepository = new CourseStudentRepository();

            Console.WriteLine(string.Format("开始获取{0}课程学员数据", courseId));
            var response = await request.PostAsync("https://console.eeo.cn/saasajax/student.ajax.php?action=getCourseStudentList", content);
            var result = response.Content.ReadAsStringAsync().Result;
            List<RB_Course_Student> list = new List<RB_Course_Student>();
            if (!string.IsNullOrWhiteSpace(result))
            {
                JObject rootObj = JObject.Parse(result);
                if (!string.IsNullOrWhiteSpace(rootObj.GetString("data")))
                {
                    JArray courseStudentArray = JArray.Parse(rootObj.GetString("data"));
                    if (courseStudentArray != null && courseStudentArray.Count > 0)
                    {
                        foreach (var jItem in courseStudentArray)
                        {
                            JObject courseStuObj = JObject.Parse(jItem.ToString());
                            list.Add(new RB_Course_Student()
                            {
                                id=courseStuObj.GetInt("id"),
                                uid=courseStuObj.GetInt("uid"),
                                name = courseStuObj.GetString("name"),
                                account = courseStuObj.GetString("account"),
                                logo= courseStuObj.GetString("logo"),
                                courseId= courseId
                            }); 
                        }
                    }
                }
            }
            if (list != null && list.Count > 0)
            {
                courseStudentRepository.BatchSetCourseStudentRepository(list);
            }
        }
    }
}
