﻿using EduSpider.Model.Entity;
using EduSpider.Repository;
using EduSpider.Utility.Enum;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Net.Http;
using System.Text;
using VTX.FW.Helper;

namespace EduSpider.Spiders.ClassInRule
{
    public class StudentManager
    {
        public async void RunAsync(string cookie)
        {
            var request = Utility.HttpHelper.GenerateHttp(cookie);
            var paramStr = "page=1&perpage=20&isdel=0";
            var content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/x-www-form-urlencoded");
            var response = await request.PostAsync("https://console.eeo.cn/saasajax/student.ajax.php?action=getSchoolStudentListByPage", content);

            var result = response.Content.ReadAsStringAsync().Result;
        }

        /// <summary>
        /// 获取课程列表
        /// </summary>
        public async void RunCourse(string cookie)
        {
            int perpage = 20;
            var request = Utility.HttpHelper.GenerateHttp(cookie);
            string paramStr =string.Format( "page={0}&perpage=20&courseState=1","1");
            var content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/x-www-form-urlencoded");
            var response = await request.PostAsync("https://console.eeo.cn/saasajax/course.ajax.php?action=getCourseList", content);

            var result = response.Content.ReadAsStringAsync().Result;
            List<RB_Course> list = new();
            if (!string.IsNullOrWhiteSpace(result))
            {
                JObject rootObj = JObject.Parse(result);
                if (!string.IsNullOrWhiteSpace(rootObj.GetString("data")))
                {
                    JObject dataObj = JObject.Parse(rootObj.GetString("data"));
                    var totalNum = dataObj.GetInt("totalCourseNum");
                    var pageCount = 1;
                    if (totalNum % 20 == 0)
                    {
                        pageCount = totalNum % 20;
                    }
                    else
                    {
                        pageCount = totalNum % 20+1;
                    }
                    if(totalNum>20)
                    JArray courseArray = JArray.Parse(dataObj.GetString("courseList"));
                    if (courseArray != null && courseArray.Count > 0)
                    {
                        foreach (var jItem in courseArray)
                        {
                            JObject courseObj = JObject.Parse(jItem.ToString());
                            list.Add(new RB_Course()
                            {
                                courseId = courseObj.GetInt("courseId"),
                                courseName=courseObj.GetString("courseName"),
                                beginTime= ConvertHelper.UnixToDateTime(courseObj.GetInt("beginTime")),
                                completeNum = courseObj.GetInt("completeNum"),
                                totalClassNum = courseObj.GetInt("totalClassNum"),
                                expiryTime = ConvertHelper.UnixToDateTime(courseObj.GetInt("expiryTime")),
                                liveNum = courseObj.GetInt("liveNum"),
                                recordNum = courseObj.GetInt("recordNum"),
                                openNum = courseObj.GetInt("openNum"),
                                studentNum = courseObj.GetInt("studentNum"),
                                auditNum = courseObj.GetInt("auditNum"),
                                teacherNum = courseObj.GetInt("teacherNum"),
                                courseStatus = (CourseStatusEnum)courseObj.GetInt("courseStatus"),
                                webCast = courseObj.GetString("webCast"),
                                teacherId = courseObj.GetInt("teacherId"),
                                teacherAccount = courseObj.GetString("teacherAccount"),
                                teacherUid = courseObj.GetInt("teacherUid"),
                                teacherName = courseObj.GetString("teacherName"),
                                teacherLogo = courseObj.GetString("teacherLogo"),
                                courseType = (CourseTypeEnum)courseObj.GetInt("courseType"),
                            });;
                        }
                    }
                }
            }
            ICourseRepository courseRepository = new CourseRepository();
            courseRepository.BatchSetCourse(list);
            Console.WriteLine("result", result);
        }


    }
}
