﻿using EduSpider.IRepository;
using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Model.Query;
using EduSpider.Repository.Base;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VTX.FW.DB;
using VTX.FW.DB.Dapper;

namespace EduSpider.Repository
{
    /// <summary>
    /// 默认评论仓储接口实现
    /// </summary>
    public class CommentRepository : BaseRepository<RB_Comment>, ICommentRepository
    {
        /// <summary>
        /// 默认评论详情接口
        /// </summary>
        CommentDetailsRepository commentDetailsRepository = new CommentDetailsRepository();


        /// <summary>
        /// 获取系统配置评价列表
        /// </summary>
        /// <returns></returns>
        public List<RB_Comment_Extend> GetCommentListRepository(CourseQuery query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new();
            builder.AppendFormat(@"
SELECT A.*
FROM RB_Comment AS A
WHERE 1=1
");
            if (!string.IsNullOrEmpty(query.KeyWords))
            {
                if (query.KeyWords.Contains("高"))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @KeyWords1 ",nameof(RB_Comment_Extend.KeyWords));
                    parameters.Add("KeyWords1", "%高%");
                }
                if (query.KeyWords.Contains("初"))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @KeyWords2 ", nameof(RB_Comment_Extend.KeyWords));
                    parameters.Add("KeyWords2", "%初%");
                }
                if (query.KeyWords.Contains("化学"))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @KeyWords3 ", nameof(RB_Comment_Extend.KeyWords));
                    parameters.Add("KeyWords3", "%化学%");
                }
                if (query.KeyWords.Contains("数学"))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @KeyWords4 ",nameof(RB_Comment_Extend.KeyWords));
                    parameters.Add("KeyWords4", "%数学%");
                }
            }
            if (query.CommentTimes > 0)
            {
                builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Comment_Extend.Times), query.CommentTimes);
            }
            if (query.DefaultCommentId > 0)
            {
                builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Comment_Extend.Id), query.DefaultCommentId);
            }
            var list = new List<RB_Comment_Extend>();
            //强制匹配关键词
            if (query.IsMatchKeyWords == 1)
            {
                if (parameters != null && parameters.ParameterNames.Count()>0)
                {
                    list = base.Get<RB_Comment_Extend>(builder.ToString(), parameters).ToList();
                }
            }
            else
            {
                list = base.Get<RB_Comment_Extend>(builder.ToString(), parameters).ToList();
            }
           
            if (list != null && list.Count>0)
            {
                string Ids = string.Join(",", list.Select(qitem => qitem.Id));
                List<RB_Comment_Details> subList = new List<RB_Comment_Details>();
                if (!string.IsNullOrEmpty(Ids))
                {
                    subList = commentDetailsRepository.GetCommentDetailsListRepository(Ids);
                }
                foreach (var item in list)
                {
                    item.Details = subList?.Where(qitem => qitem.CommentId == item.Id)?.OrderBy(qitem => qitem.StartNum)?.ToList();
                }
                
            }
            return list;
        }
    }
}
