﻿using EduSpider.IRepository;
using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Model.Query;
using EduSpider.Repository.Base;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EduSpider.Repository
{
    /// <summary>
    /// 课程评价配置仓储接口实现
    /// </summary>
    public class CourseCommentRepository : BaseRepository<RB_Course_Comment>, ICourseCommentRepository
    {
        /// <summary>
        /// 课程评价配置详情仓储对象
        /// </summary>
        private readonly CourseCommentDetailsRepository courseCommentDetailsRepository = new();

        /// <summary>
        /// 批量新增修改课程评价
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetCourseCommentRepository(RB_Course_Comment_Extend model)
        {
            bool flag;
            if (model.Id > 0)
            {
                Dictionary<string, object> fileds = new()
                {
                    { nameof(RB_Course_Comment_Extend.Title), model.Title },
                    { nameof(RB_Course_Comment_Extend.ShowType), model.ShowType },
                };
                flag = base.UpdateOne(fileds, new VTX.FW.DB.WhereHelper(nameof(RB_Course_Comment_Extend.Id), model.Id));
            }
            else
            {
                var newId = base.Insert(model);
                model.Id = newId;
                flag = newId > 0;
            }
            if (model.CommentDetails != null && model.CommentDetails.Count > 0)
            {
                foreach (var item in model.CommentDetails)
                {
                    item.CourseCommentId = model.Id;
                }
                flag = courseCommentDetailsRepository.SetCourseCommentDetailsRepository(model.CommentDetails);
            }
            return flag;
        }

        /// <summary>
        /// 获取课程评价配置列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_Comment_Extend> GetCourseCommentListRepository(CourseQuery query)
        {
            StringBuilder builder = new();
            builder.AppendFormat(@"
SELECT A.*
FROM  RB_Course_Comment AS A
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}=0 ", nameof(RB_Course_Comment_Extend.Status));
            if (query != null)
            {
                if (query.CourseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Course_Comment_Extend.CourseId), query.CourseId);
                }
                if (!string.IsNullOrEmpty(query.QCourseIds))
                {
                    builder.AppendFormat(" AND A.{0} IN({1}) ", nameof(RB_Course_Comment_Extend.CourseId), query.QCourseIds);
                }
                if (query.CommentTimes > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Course_Comment_Extend.Times), query.CommentTimes);
                }
            }
            var list = Get<RB_Course_Comment_Extend>(builder.ToString()).ToList();
            if (list != null && list.Count > 0)
            {
                string Ids = string.Join(",", list.Select(qitem => qitem.Id));
                List<RB_Course_CommentDetails_Extend> detailsList = courseCommentDetailsRepository.GetCourseCommentDetailsListRepository(new RB_Course_CommentDetails_Extend() { QCourseCommentIds = Ids });
                foreach (var item in list)
                {
                    item.CommentDetails = detailsList?.Where(qitem => qitem.CourseCommentId == item.Id)?.ToList() ?? new List<RB_Course_CommentDetails_Extend>();
                }
            }
            return list;
        }

        /// <summary>
        /// 根据编号删除课程评价配置
        /// </summary>
        /// <param name="Ids"></param>
        /// <returns></returns>
        public bool DeleteCourseCommentRepository(string Ids)
        {
            string sql = string.Format("UPDATE  RB_Course_Comment SET Status=1 WHERE Id IN({0}) ", Ids);
            string sql2= string.Format("UPDATE  RB_Course_CommentDetails SET Status=1 WHERE CourseCommentId IN({0}) ", Ids);
            base.Execute(sql2);
            return base.Execute(sql) > 0;
        }
 
    }
}
