﻿using EduSpider.Model.Entity;
using EduSpider.Model.Query;
using System.Collections.Generic;
using VTX.FW.Config;
using VTX.FW.DB;

namespace EduSpider.Repository
{
    /// <summary>
    /// 课程仓储接口
    /// </summary>
    public interface ICourseRepository : IDBRepository<rb_course_hk>, IDependency
    {
        /// <summary>
        /// 批量新增课程
        /// </summary>
        /// <param name="courses"></param>
        /// <returns></returns>
        public bool BatchSetCourseRepository(List<rb_course_hk> courses);

        /// <summary>
        /// 批量新增修改课程指定字段
        /// </summary>
        /// <param name="courses"></param>
        /// <returns></returns>
        public bool BatchSetCourseOtherRepository(List<rb_course_hk> courses);

        /// <summary>
        /// 批量修改录树
        /// </summary>
        /// <param name="courses"></param>
        /// <returns></returns>
        public bool BatchSetCourseRecordNumRepository(List<rb_course_hk> courses);

        /// <summary>
        /// 获取课程分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<rb_course_hk> GetCoursePageRepository(int pageIndex, int pageSize, out long rowsCount, CourseQuery query);

        /// <summary>
        /// 获取课程列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<rb_course_hk> GetCourseListRepository(CourseQuery query);
    }
}
