﻿using EduSpider.Model.Entity;
using EduSpider.Model.Query;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VTX.FW.Config;
using VTX.FW.DB;

namespace EduSpider.IRepository
{
    /// <summary>
    /// 作业仓储层接口
    /// </summary>
    public interface IHomeWorkRepository : IDBRepository<RB_HomeWork>, IDependency
    {
        /// <summary>
        /// 批量添加家庭作业
        /// </summary>
        /// <param name="homeWorks"></param>
        /// <returns></returns>
        public bool BatchSetHomeWorkRepository(List<RB_HomeWork> homeWorks);

        /// <summary>
        /// 获取课程作业列表
        /// </summary>
        /// <param name="homeWorks"></param>
        /// <returns></returns>
        public List<RB_HomeWork> GetCourseHomeWorkListRepository(CourseQuery query);
    }
}
