﻿using System;

namespace EduSpider.Model.Query
{
    /// <summary>
    /// 课程查询实体类
    /// </summary>
    public class CourseQuery
    {
        /// <summary>
        /// 课程编号
        /// </summary>
        public int CourseId { get; set; }

        /// <summary>
        /// 课程编号【多个】
        /// </summary>
        public string QCourseIds { get; set; }

        /// <summary>
        /// 课程名称
        /// </summary>
        public string CourseName { get; set; }

        /// <summary>
        /// 学员编号
        /// </summary>
        public string StuIds { get; set; }

        /// <summary>
        /// 教师编号
        /// </summary>
        public string TeacherIds { get; set; }

        /// <summary>
        /// 课程状态(0-全部,1-进行中，2,-已完成)
        /// </summary>
        public int QCourseState { get; set; }

        /// <summary>
        /// 关键词
        /// </summary>
        public string KeyWords { get; set;}

        /// <summary>
        /// 是否强制匹配关键词
        /// </summary>
        public int IsMatchKeyWords { get; set; }

        /// <summary>
        /// 作业编号
        /// </summary>
        public Int64 HomeWorkId { get; set; }

        /// <summary>
        /// 作业编号
        /// </summary>
        public string QHomeWorkIds { get; set; }

        /// <summary>
        /// 创建类型(1-系统创建，2-老师创建)
        /// </summary>
        public int CreateCommentType { get; set; }

        /// <summary>
        /// 评论次数
        /// </summary>
        public int CommentTimes { get; set; }

        /// <summary>
        /// 默认评价编号
        /// </summary>
        public int DefaultCommentId { get; set; }

        /// <summary>
        /// 学员作业编号
        /// </summary>
        public long Stu_HomeWork_Id { get; set; }
    }
}
