﻿using EduSpider.IRepository;
using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Repository.Base;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EduSpider.Repository
{
    /// <summary>
    /// 课程评价配置详情仓储接口实现
    /// </summary>
    public class CourseCommentDetailsRepository : BaseRepository<RB_Course_CommentDetails>, ICourseCommentDetailsRepository
    {
        /// <summary>
        /// 新增修改课程评价
        /// </summary>
        /// <param name="list"></param>
        /// <returns></returns>
        public bool SetCourseCommentDetailsRepository(List<RB_Course_CommentDetails_Extend> list)
        {
            bool flag = true;
            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    if (flag)
                    {
                        if (item.DetailId > 0)
                        {
                            Dictionary<string, object> fileds = new()
                            {
                                {nameof(RB_Course_CommentDetails.StartNum),item.StartNum },
                                {nameof(RB_Course_CommentDetails.EndNum),item.EndNum },
                                {nameof(RB_Course_CommentDetails.Info),item.Info },
                            };
                            flag = base.UpdateOne(fileds, new VTX.FW.DB.WhereHelper(nameof(RB_Course_CommentDetails.DetailId), item.DetailId));
                        }
                        else
                        {
                            var newId = base.Insert(item);
                            item.DetailId = newId;
                            flag = newId > 0;
                        }
                    }
                }
            }
            return flag;
        }

        /// <summary>
        /// 获取课程评价配置列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_CommentDetails_Extend> GetCourseCommentDetailsListRepository(RB_Course_CommentDetails_Extend query)
        {
            StringBuilder builder = new();
            builder.AppendFormat(@"
SELECT A.*
FROM RB_Course_CommentDetails AS A
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}=0 ", nameof(RB_Course_CommentDetails_Extend.Status));
            if (query != null)
            {
                if (!string.IsNullOrEmpty(query.QCourseCommentIds))
                {
                    builder.AppendFormat(" AND A.{0} IN({1}) ", nameof(RB_Course_CommentDetails_Extend.CourseCommentId), query.QCourseCommentIds);
                }
            }
            return Get<RB_Course_CommentDetails_Extend>(builder.ToString()).ToList();
        }

        /// <summary>
        /// 根据编号删除课程评价详情配置
        /// </summary>
        /// <param name="DetailIds"></param>
        /// <returns></returns>
        public bool DeleteCourseCommentDetailsRepository(string DetailIds)
        {
            string sql = string.Format(" UPDATE RB_Course_CommentDetails SET Status=1 WHERE DetailId IN({0}) ", DetailIds);
            return base.Execute(sql) > 0;
        }
    }
}
