﻿using EduSpider.Model.Entity;
using EduSpider.Model.Query;
using EduSpider.Repository.Base;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VTX.FW.DB.Dapper;

namespace EduSpider.Repository
{
    /// <summary>
    /// 课程仓储层
    /// </summary>
    public class CourseRepository : BaseRepository<rb_course_hk>, ICourseRepository
    {
        /// <summary>
        /// 批量新增课程
        /// </summary>
        /// <param name="courses"></param>
        /// <returns></returns>
        public bool BatchSetCourseRepository(List<rb_course_hk> courses)
        {
            bool flag;
            flag = base.BatchInsert(courses, isReplace: true);
            return flag;
        }

        /// <summary>
        /// 批量修改其他字段
        /// </summary>
        /// <param name="courses"></param>
        /// <returns></returns>
        public bool BatchSetCourseOtherRepository(List<rb_course_hk> courses)
        {
            var parameters = new DynamicParameters();
            string sql = @" 
UPDATE rb_course_hk 
SET courseWare=@courseWare,coverImg=@coverImg,courseType=@courseType,addTime=@addTime
WHERE courseId=@courseId ";
            parameters.Add("courseWare", courses[0].CourseWare);
            parameters.Add("coverImg", courses[0].CoverImg);
            parameters.Add("courseType", courses[0].CourseType);
            parameters.Add("addTime", courses[0].AddTime);
            parameters.Add("courseId", courses[0].CourseId);
            return Execute(sql, parameters) > 0;
        }



        /// <summary>
        /// 批量修改其他字段
        /// </summary>
        /// <param name="courses"></param>
        /// <returns></returns>
        public bool BatchSetCourseRecordNumRepository(List<rb_course_hk> courses)
        {
            var parameters = new DynamicParameters();
            string sql = @" 
UPDATE rb_course_hk 
SET RecordNum=@RecordNum
WHERE courseId=@courseId ";

            parameters.Add("RecordNum", courses[0].RecordNum);
            parameters.Add("courseId", courses[0].CourseId);
            return Execute(sql, parameters) > 0;
        }

        /// <summary>
        /// 获取课程列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<rb_course_hk> GetCourseListRepository(CourseQuery query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new();
            builder.AppendFormat(@"
SELECT A.*
FROM rb_course_hk AS A
WHERE 1=1
");
            if (query != null)
            {
                if (!string.IsNullOrWhiteSpace(query.CourseName))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @courseName ", nameof(rb_course_hk.CourseName));
                    parameters.Add("courseName", "%" + query.CourseName.Trim() + "%");
                }
                if (query.CourseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(rb_course_hk.CourseId), query.CourseId);
                }
            }
            return base.Get<rb_course_hk>(builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 获取课程分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<rb_course_hk> GetCoursePageRepository(int pageIndex, int pageSize, out long rowsCount, CourseQuery query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new();
            builder.AppendFormat(@"
SELECT A.*
FROM rb_course_hk AS A
WHERE 1=1
");
            if (query != null)
            {
                if (!string.IsNullOrWhiteSpace(query.CourseName))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @courseName ", nameof(rb_course_hk.CourseName));
                    parameters.Add("courseName", "%" + query.CourseName.Trim() + "%");
                }
                if (query.CourseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(rb_course_hk.CourseId), query.CourseId);
                }
            }
            return base.GetPage<rb_course_hk>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }
    }
}
