﻿using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Configuration.Json;
using System;
using System.IO;
using System.Text.RegularExpressions;
using VTX.FW.Helper;

namespace EduSpider.Utility
{
    /// <summary>
    /// 全局配置
    /// </summary>
    public class Config
    {
        /// <summary>
        /// 配置文件注入
        /// </summary>
        public readonly static IConfiguration Configuration;
        static Config()
        {
            try
            {
                Configuration = new ConfigurationBuilder()
                .Add(new JsonConfigurationSource { Path = "appsettings.json", ReloadOnChange = true })
                .Build();
            }
            catch (Exception ex)
            {
                LogHelper.WriteError("Config", "获取配置文件", ex);
            }
        }

        /// <summary>
        /// 获取连接字符串
        /// </summary>
        /// <param name="key"></param>
        /// <returns></returns>
        public static string GetConnectionString(string key)
        {
            try
            {
                return Configuration.GetConnectionString(key);
            }
            catch
            {
                return "";
            }
        }


        /// <summary>
        /// 读取配置文件key的值
        /// </summary>
        /// <param name="key"></param>
        /// <returns></returns>
        public static string ReadConfigKey(string key, string subKey = "")
        {
            string valueStr = "";
            try
            {
                if (!string.IsNullOrWhiteSpace(subKey))
                {
                    valueStr = Configuration.GetSection(key)[subKey].ToString();
                }
                else
                {
                    valueStr = Configuration.GetSection(key).Value;
                }
            }
            catch
            {
            }
            return valueStr;
        }

        /// <summary>
        /// 异常日志保存路径
        /// </summary>
        public static string LogPath
        {
            get
            {
                string logPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "log/error");
                return logPath.ToString();
            }
        }

        /// <summary>
        /// 打印日志保存路径
        /// </summary>
        public static string InofLogPath
        {
            get
            {
                string logPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "log/info");
                return logPath.ToString();
            }
        }

        /// <summary>
        /// 接口请求日志保存路径
        /// </summary>
        public static string RequestLogPath
        {
            get
            {
                string logPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "log/request");
                return logPath.ToString();
            }
        }

        /// <summary>
        /// JWT加密秘钥
        /// </summary>
        public static string JwtSecretKey
        {
            get
            {
                return ReadConfigKey("JwtSecretKey");
            }
        }

        /// <summary>
        /// 过期时间，单位为秒
        /// </summary>
        public static int JwtExpirTime
        {
            get
            {
                Int32.TryParse(ReadConfigKey("JwtExpirTime"), out int JwtExpirTime);
                return JwtExpirTime;
            }
        }

        /// <summary>
        /// 获取文件相对路径
        /// </summary>
        public static string GetFilePath(string path)
        {
            if (!string.IsNullOrWhiteSpace(path))
            {
                string p = @"(http|https)://(?<domain>[^(:|/]*)";
                Regex reg = new Regex(p, RegexOptions.IgnoreCase);
                string value = reg.Match(path).Value;
                if (!string.IsNullOrEmpty(value))
                {
                    Uri url = new Uri(path);
                    return url.AbsolutePath;
                }
                else
                {
                    return path;
                }
            }
            else
            {
                return path;
            }
        }

        /// <summary>
        /// 进阶成长树AppId
        /// </summary>
        public static string AppID
        {
            get { return "wx10655d8e5b0a67c5"; }
        }

        /// <summary>
        /// 进阶成长树AppSecret
        /// </summary>
        public static string AppSecret
        {
            get { return "25b84987f53f9aaa62f56c6c25b7ccd6"; }
        }

        /// <summary>
        /// 微信小程序Api地址
        /// </summary>
        public static string WechatApi
        {
            get { return "https://api.weixin.qq.com/"; }
        }

        /// <summary>
        /// 是否是本地服务器
        /// </summary>
        public static int IsLocal
        {
            get
            {
                Int32.TryParse(ReadConfigKey("IsLocal"), out int _IsLocal);
                return _IsLocal;
            }
        }

    }
}