﻿using EduSpider.Spiders.ClassInRule;
using EduSpider.Utility.Plugin;

namespace TicketSpider.Spiders.ClassInRule
{
    public class ClassInFlow
    {
        /// <summary>
        /// 导入ClassIn数据
        /// </summary>
        public void StartAsync()
        {
            VTX.FW.Helper.LogHelper.WriteInfo("RunClassInData", "开始ClassIn数据");
            InfoHelper.WriteLine("开始模拟登录信息.......");
            VTX.FW.Helper.LogHelper.WriteInfo("StartAsync", "开始模拟登录信息.......");
            string loginCookies = VTX.FW.Helper.ConfigHelper.GetAppsettings("DefaultToken");
            //自定获取Cookie
            if (string.IsNullOrEmpty(loginCookies))
            {
                ClassInAccountManager.ClearCookie();
                var KeyTypeStr= VTX.FW.Helper.ConfigHelper.GetAppsettings("ClassInType");
                string key = EduSpider.Cache.CacheKey.ClassIn_Cookie_Key+"_"+ KeyTypeStr;
                int ExpirTime = 60 * 60 * 12;
                var cacheCookie = EduSpider.Cache.User.UserReidsCache.GetClassInCookie(key);
                if (cacheCookie != null && !string.IsNullOrEmpty(cacheCookie.CacheCookies.ToString()))
                {
                    loginCookies = cacheCookie.CacheCookies;
                }
                else
                {
                    loginCookies = ClassInAccountManager.GetInstance();
                    if (!string.IsNullOrEmpty(loginCookies))
                    {
                        EduSpider.Cache.User.UserReidsCache.ClassInCookieSet(key, new EduSpider.Cache.User.ClassInTokenItem() { CacheCookies = loginCookies }, ExpirTime);
                    }
                }
            }

            InfoHelper.WriteLine("cookies:" + loginCookies);
            VTX.FW.Helper.LogHelper.WriteInfo("StartAsync", "cookies：" + loginCookies);

            InfoHelper.WriteLine("开始获取老师信息");
            VTX.FW.Helper.LogHelper.WriteInfo("StartAsync", "开始获取老师信息");
            TeacherManager.RunTeacher(loginCookies);
            InfoHelper.WriteLine("老师信息更新结束");
            VTX.FW.Helper.LogHelper.WriteInfo("StartAsync", "老师信息更新结束");

            InfoHelper.WriteLine("开始获取学生信息");
            VTX.FW.Helper.LogHelper.WriteInfo("StartAsync", "开始获取学生信息");
            StudentManager.RunAsync(loginCookies);
            InfoHelper.WriteLine("学生信息更新结束");
            VTX.FW.Helper.LogHelper.WriteInfo("StartAsync", "学生信息更新结束");

            InfoHelper.WriteLine("开始获取课程信息");
            VTX.FW.Helper.LogHelper.WriteInfo("StartAsync", "开始获取课程信息");
            CourseManager.RunCourse(loginCookies);
            InfoHelper.WriteLine("课程信息更新结束");
            VTX.FW.Helper.LogHelper.WriteInfo("StartAsync", "课程信息更新结束");

            InfoHelper.WriteLine("开始获取作业信息");
            VTX.FW.Helper.LogHelper.WriteInfo("StartAsync", "开始获取作业信息");
            HomeWorkManager.RunHomeWork(loginCookies);
            InfoHelper.WriteLine("作业信息更新结束");
            VTX.FW.Helper.LogHelper.WriteInfo("StartAsync", "作业信息更新结束");

            InfoHelper.WriteLine("开始获取测验信息");
            VTX.FW.Helper.LogHelper.WriteInfo("StartAsync", "开始测验信息");
            QuestionManager.RunHomeWork(loginCookies);
            InfoHelper.WriteLine("测验信息更新结束");
            VTX.FW.Helper.LogHelper.WriteInfo("StartAsync", "测验信息更新结束");
        }
    }
}
