﻿using EduSpider.IRepository;
using EduSpider.Model.Entity;
using EduSpider.Repository;
using EduSpider.Utility;
using EduSpider.Utility.Plugin;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http;
using System.Text;
using VTX.FW.Helper;

namespace EduSpider.Spiders.ClassInRule
{
    public class StudentManager
    {

        private static readonly IStudentRepository courseRepository = new StudentRepository();

        /// <summary>
        /// 获取学生数据
        /// </summary>
        /// <param name="cookie"></param>
        public static async void RunAsync(string cookie)
        {
            var request = Utility.HttpHelper.GenerateHttp(cookie);
            int pageIndex = 1, pageCount = 1, pageSize = 500;

            #region 获取最大学生ID
            //更新账户
            IAccountRepository accountRepository = new AccountRepository();
            //获取账户表 最大的TeacherId 
            int MaxStuId = accountRepository.GetMaxStuTeaId(type: 2);
            List<rb_account_hk> accountList = new();
            #endregion

            while (pageIndex <= pageCount)
            {
                InfoHelper.WriteLine($"正在查询第{pageIndex}-{pageSize}页学员信息");
                VTX.FW.Helper.LogHelper.WriteInfo("RunAsync", $"正在查询第{pageIndex}-{pageSize}页学员信息");
                var paramStr = $"page={pageIndex}&perpage={pageSize}&isdel=0";
                var content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/x-www-form-urlencoded");
                try
                {
                    var response = await request.PostAsync("https://console.eeo.cn/saasajax/student.ajax.php?action=getSchoolStudentListByPage", content);
                    var resultStr = response.Content.ReadAsStringAsync().Result ?? string.Empty;
                    var result = resultStr.TryToJObject();
                    if (result.flag)
                    {
                        var data = (result.val.ContainsKey("data") ? result.val["data"] : new JObject()) as JObject;
                        if (data.ContainsKey("totalStudentNum"))
                        {
                            #region 更新PageCount
                            if (pageIndex == 1)
                            {
                                pageCount = (int)Math.Ceiling(data.GetDecimal("totalStudentNum") / pageSize);
                            }
                            #endregion

                            #region 组装实体
                            var stus = new List<rb_student_hk>();
                            var stuArray = (data["studentList"] as JArray);
                            string accountIds = "";
                            foreach (JObject x in stuArray)
                            {
                                var xModel = new rb_student_hk()
                                {
                                    AddTime = ConvertHelper.UnixToDateTime(x.GetString("addTime")),
                                    StudentAccount = x.GetString("studentAccount"),
                                    Isdel = x.GetInt("isdel", 0),
                                    IsGroup = x.GetInt("isGroup", 0),
                                    StudId = x.GetInt("studId", 0),
                                    Progress = x.GetString("progress"),
                                    PublicResourceStatus = x.GetInt("publicResourceStatus", 0),
                                    ServeState = x.GetInt("serveState", 0),
                                    StudentName = x.GetString("studentName"),
                                    StudentUid = x.GetInt("studentUid", 0),
                                    Stuno = x.GetString("stuno"),
                                };
                                if (string.IsNullOrEmpty(xModel.StudentAccount))
                                {
                                    string mobile = x.GetString("mobile");
                                    if (!string.IsNullOrEmpty(mobile))
                                    {
                                        xModel.StudentAccount = mobile;
                                    }
                                }
                                accountIds += string.Format(",'{0}'", xModel.StudentAccount);
                                stus.Add(xModel);
                            }
                            courseRepository.BatchSetStudent(stus);
                            InfoHelper.WriteLine($"已导入第{pageIndex}-{pageSize}页学员信息");
                            VTX.FW.Helper.LogHelper.WriteInfo("RunAsync", $"已导入第{pageIndex}-{pageSize}页学员信息");
                            #endregion

                            #region 写入账号
                            if (stus.Any())
                            {
                                var stuAccountList = accountRepository.GetStuAccountList(2, accountIds.TrimStart(','));
                                foreach (var item in stus)
                                {
                                    var tempAccount = stuAccountList?.FirstOrDefault(qitem => qitem.Id == item.StudId && qitem.Account == item.StudentAccount && qitem.AccountId == item.StudentUid);
                                    accountList.Add(new rb_account_hk()
                                    {
                                        UniqueId = tempAccount?.UniqueId ?? 0,
                                        Id = item.StudId,
                                        Account = item.StudentAccount,
                                        AccountId = item.StudentUid,
                                        AccountType = Utility.Enum.AccountTypeEnum.Student,
                                        OpenId = "",
                                        Password = DESHepler.Encrypt(item.StudentAccount[^6..]),
                                        Status = 0,
                                        UnionId = ""
                                    });
                                }
                            }
                            #endregion
                        }
                    }
                }
                catch (Exception ex)
                {
                    VTX.FW.Helper.LogHelper.WriteError("StudentManager_RunAsync", ex: ex);
                }
                pageIndex++;
            }

            #region 插入账号
            if (accountList.Any())
            {
                accountRepository.BatchSetAccount(accountList);
            }
            #endregion

            InfoHelper.WriteLine("学员同步完成");
            VTX.FW.Helper.LogHelper.WriteInfo("RunAsync", $"学员同步完成");
        }
    }
}
