﻿using EduSpider.Utility.Plugin;
using OpenQA.Selenium;
using OpenQA.Selenium.Chrome;
using System;
using System.Net;
using System.Net.Http;
using System.Threading;
using System.Threading.Tasks;

namespace EduSpider.Spiders.SchoolHouseKeeper
{
    /// <summary>
    /// 校管家
    /// </summary>
    public class AccountHelper
    {

        private static readonly object lockerSafe = new();

        private static string _loginCookies = "";

        private static bool _openHeartTimer = false;

        public static string GetInstance()
        {
            if (string.IsNullOrEmpty(_loginCookies))
            {
                lock (lockerSafe)
                {
                    if (string.IsNullOrEmpty(_loginCookies))
                    {
                        _loginCookies = string.Empty;
                        var cnt = 0;
                        while (cnt < 4)
                        {
                            cnt++;
                            var result = RunAsync();
                            if (result && !_openHeartTimer)
                            {
                                _openHeartTimer = true;
                                Task.Run(() => HeartLine());
                                break;
                            }
                            else
                            {
                                InfoHelper.WriteLine("开始重新尝试登录校管家");
                                Thread.Sleep(2000);
                            }
                        }
                    }
                }
            }
            return _loginCookies;
        }


        public static bool RunAsync()
        {
            var flag = false;
            IWebElement inputEle;
            IWebElement pwdEle;
            var option = new ChromeOptions();
            option.AddArgument("--incognito");
            option.AddArgument("headless");
            option.AddArgument("disable-infobars");
            option.AddArgument("window-size=1920,1080");
            option.AddArgument("user-agent=Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/101.0.4951.41 Safari/537.36");
            ChromeDriverService service = ChromeDriverService.CreateDefaultService(Environment.CurrentDirectory);
            service.HideCommandPromptWindow = true;
            option.PageLoadStrategy = PageLoadStrategy.Eager;
            IWebDriver driver = new ChromeDriver(service, option);
            try
            {
                driver.Navigate().GoToUrl($"https://tms.xiaogj.com/login.aspx");
                driver.Manage().Timeouts().PageLoad = TimeSpan.FromSeconds(15);
                inputEle = driver.FindElement(By.Id("name"));
                pwdEle = driver.FindElement(By.Id("pwd"));
                if (inputEle != null && pwdEle != null)
                {
                    inputEle.SendKeys("刘帅@jjsw");
                    pwdEle.SendKeys("ls123456");
                    var buttonEle = driver.FindElement(By.Id("loginBtn"));
                    Thread.Sleep(1000);
                    //开始登录
                    buttonEle.Click();
                    Thread.Sleep(1000);
                    var cookies = driver.Manage().Cookies.AllCookies;
                    //处理Cookie
                    foreach (var item in cookies)
                    {
                        _loginCookies += item.Name + "=" + item.Value + ";";
                    }
                    _loginCookies = _loginCookies.Substring(0, _loginCookies.Length - 1);
                    if (!string.IsNullOrEmpty(_loginCookies) && _loginCookies.Contains("ASP.NET_SessionId")
                       && _loginCookies.Contains(".ASPXAUTH")
                        )
                    {
                        flag = true;
                    }
                    else
                    {
                        _loginCookies = "";
                        flag = false;
                    }
                }
            }
            catch (Exception ex)
            {
                InfoHelper.WriteLine($"获取cooki失败，{ex.Message}");
            }
            driver.Quit();
            InfoHelper.WriteLine("完成登录...");
            return flag;
        }


        private static void HeartLine()
        {
            while (_openHeartTimer)
            {
                var handler = new HttpClientHandler
                {
                    AllowAutoRedirect = false,
                    UseCookies = true,
                    CookieContainer = CreateCookie(),
                    AutomaticDecompression = DecompressionMethods.GZip,
                    ClientCertificateOptions = ClientCertificateOption.Automatic
                };
                var http = new HttpClient(handler);
                http.GetAsync("https://tms11.xiaogj.com/");
                //TODO:检查是否需要重新登录
                Thread.Sleep(60 * 1000);
            }
        }

        public static void StopHeartLine()
        {
            _openHeartTimer = false;
        }

        private static CookieContainer CreateCookie()
        {
            var uri = new Uri("https://tms11.xiaogj.com");
            var cc = new CookieContainer();
            foreach (var str in _loginCookies.Split(';'))
            {
                cc.SetCookies(uri, str);
            }
            return cc;
        }

    }
}
