﻿using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Repository.Base;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VTX.FW.DB.Dapper;

namespace EduSpider.Repository
{
    /// <summary>
    /// 考试仓储层
    /// </summary>
    public class ExamRepository : BaseRepository<RB_Exam>, IExamRepository
    {
        /// <summary>
        /// 获取分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Exam_Extend> GetExamPageList(int pageIndex, int pageSize, out long count, RB_Exam_Extend demodel)
        {
            var parameters = new DynamicParameters();
            string where = " 1=1 and e.Status =0";
            if (demodel.CourseId > 0)
            {
                where += $@" and e.{nameof(RB_Exam_Extend.CourseId)} ={demodel.CourseId}";
            }
            if (!string.IsNullOrEmpty(demodel.ExamName)) {
                where += $@" and e.{nameof(RB_Exam_Extend.ExamName)} like @ExamName";
                parameters.Add("ExamName", "%" + demodel.ExamName.Trim() + "%");
            }
            if (demodel.CreateBy > 0)
            {
                where += $@" and e.{nameof(RB_Exam_Extend.CreateBy)} ={demodel.CreateBy}";
            }

            string sql = $@"select e.*,es.StuNum,es.TScore,es.FailNum FROM rb_exam e
LEFT JOIN (
	SELECT e.ExamId,COUNT(0) as StuNum,SUM(e.TScore) as TScore,sum(case when e.StuId=0 then 1 else 0 end) as FailNum FROM rb_exam_score e GROUP BY e.ExamId
) es on e.ExamId = es.ExamId 
where {where} order by e.ExamId desc";
            return GetPage<RB_Exam_Extend>(pageIndex, pageSize, out count, sql, parameters).ToList();
        }
    }
}
