﻿using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Model.Query;
using System.Collections.Generic;
using VTX.FW.Config;
using VTX.FW.DB;

namespace EduSpider.IRepository
{
    /// <summary>
    /// 学员评语仓储接口
    /// </summary>
    public interface IStuCommentRepository:IDBRepository<RB_Stu_Comment>, IDependency
    {
        /// <summary>
        /// 新增修改学员评语
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetStuCommentRepository(RB_Stu_Comment model);

        /// <summary>
        /// 批量新增学员评价
        /// </summary>
        /// <param name="list"></param>
        /// <returns></returns>
        public bool BatchSetStuCommentRepository(List<RB_Stu_Comment> list);


        /// <summary>
        /// 查询学员评语列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Stu_Comment> GetStuCommentListRepository(CourseQuery query);

        /// <summary>
        /// 修改学员评论状态
        /// </summary>
        /// <param name="ShowType"></param>
        /// <param name="Ids"></param>
        /// <returns></returns>
        public bool SetStuCommentShowTypeRepository(int ShowType, string Ids);

        /// <summary>
        /// 根据课程评论次数修改可见等级
        /// </summary>
        /// <param name="CourseId">课程编号</param>
        /// <param name="Times">次数</param>
        /// <param name="ShowType">可见性</param>
        /// <returns></returns>
        public bool SetStuCommentShowTypeByTimesRepository(int CourseId,int Times,int ShowType);

        /// <summary>
        /// 根据编号删除学员评论
        /// </summary>
        /// <param name="Ids"></param>
        /// <returns></returns>
        public bool DeleteStuCommentRepository(string Ids);

        /// <summary>
        /// 获取系统生成评论次数 
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Stu_Comment> GetCourseCommentTimesListRepository(CourseQuery query);

        /// <summary>
        /// 获取评论列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Stu_Comment_Extend> GetStuCommentList(CourseQuery query);
    }
}
